/*----------------------------------------------------------------------------
 * Name:    Blinky.c
 * Purpose: LED Flasher for STM32F746G-Discovery
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2004-2015 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include "stm32f7xx_hal.h"
#include "Board_LED.h"
#include "Board_Buttons.h"
#include "RTE_Components.h"
#include "clock.c"

extern int Thread_LED(void);
volatile uint32_t msTicks;               /* counts 1ms timeTicks       */
 
/*----------------------------------------------------------------------------
  SysTick_Handler
 *----------------------------------------------------------------------------*/
void SysTick_Handler(void) {
  msTicks++;
}

/*----------------------------------------------------------------------------
  delays number of tick Systicks (happens every 1 ms)
 *----------------------------------------------------------------------------*/
void Delay (uint32_t dlyTicks) {                                              
  uint32_t curTicks;

  curTicks = msTicks;
  while ((msTicks - curTicks) < dlyTicks);
}


/**----------------------------------------------------------------------------
  * Main function
------------------------------------------------------------------------------*/

int main (void) {

  MPU_Config();                             /* Configure the MPU              */
  CPU_CACHE_Enable();                       /* Enable the CPU Cache           */
	HAL_Init();                               /* Initialize the HAL Library     */
  SystemClock_Config();                     /* Configure the System Clock     */

	SystemCoreClockUpdate();
	LED_Initialize();                         /* LED Initialization             */
  Buttons_Initialize();                     /* Buttons Initialization         */

  while (1) {

		Thread_LED();
		if (Buttons_GetState()){        /* Slow blinking while holding USER button */
		Delay(500);
		}
   }
}
