/*----------------------------------------------------------------------------
 * CRC32 ROM Self-Test Example ANxxx
 *---------------------------------------------------------------------------*/

#define osObjectsPublic                     // define objects in main module
#include "osObjects.h"                      // RTOS object definitions
#include "CRC32.h"

uint32_t crc_nominal __attribute__((at(0x0003FFFC)));
#define ROM_START 0x00000000
#define ROM_LEN   0x0003FFFC


enum system_exceptions_t
{
   SELFTEST_ROM_MISMATCH = 1
};

void raise_exception(enum system_exceptions_t fault_code, uint32_t param) {
	switch (fault_code) {
		case SELFTEST_ROM_MISMATCH:
			//handle invalid ROM image exception
			break;
	}
}


/*
 * main: initialize and start the system
 */
int main (void) {
	uint32_t crc_actual = 0;
  
	crc_actual = crc32_fdl(0,(void*)ROM_START,ROM_LEN);
	if (crc_actual != crc_nominal) {
		raise_exception(SELFTEST_ROM_MISMATCH, NULL);
	}
	
	crc_actual = crc32_fsl(0,(void*)ROM_START,ROM_LEN);
	if (crc_actual != crc_nominal) {
		raise_exception(SELFTEST_ROM_MISMATCH, NULL);
	}

	crc_actual = crc32_snl(0,(void*)ROM_START,ROM_LEN);
	if (crc_actual != crc_nominal) {
		raise_exception(SELFTEST_ROM_MISMATCH, NULL);
	}

	osKernelInitialize ();                    // initialize CMSIS-RTOS
  // initialize peripherals here
	
  // create 'thread' functions that start executing,
  // example: tid_name = osThreadCreate (osThread(name), NULL);

	osKernelStart ();                         // start thread execution 
}
