
#include <cmsis_os.h>                                           // CMSIS RTOS header file
#include "Board_LED.h" 
#include "Board_Buttons.h"
#include "Board_ADC.h" 
#include "rl_fs.h"
#include "rl_usb.h"
#include "USBD_MSC_0.h"               
#include <stdio.h>

/*----------------------------------------------------------------------------
 *      Thread 1 'Thread_Name': Sample thread
 *---------------------------------------------------------------------------*/
 
void Thread (void const *argument);                             // thread function
osThreadId tid_Thread;                                          // thread id
osThreadDef (Thread, osPriorityNormal, 1, 0);                   // thread object
extern void PrintTimeStamp(FILE *f);

typedef enum {
  DEV_IDLE,
  DEV_START_RECORD,
  DEV_STOP_RECORD,
  DEV_RECORDING
} DeviceState;
DeviceState gState = DEV_IDLE; 
FILE *f_but;
FILE *f_adc;
                                  
void SetRecording(bool bMode) {
  if (bMode) {
    if (gState==DEV_IDLE) gState = DEV_START_RECORD;
  } else {
    if (gState==DEV_RECORDING) gState = DEV_STOP_RECORD;
  }
}
                                          
void LogButton(uint8_t button, uint8_t state) {
const char ButName[][7] = {"1", "2"};
const char ButState[][9] = {"Released", "Pressed"};
  if (f_but != NULL) {
    PrintTimeStamp(f_but);  
    fprintf(f_but," - Button %s %s\n",ButName[button],ButState[state]);
  }  
}
                                                
void LogADC(uint16_t val) {
  if (f_adc != NULL) {
    PrintTimeStamp(f_adc);
    fprintf (f_adc," - 0x%04X - %4.2fV\n", val, (float) (val * 3.3 / (1 << ADC_GetResolution ())));
  }  
}

int Init_Thread (void) {

  tid_Thread = osThreadCreate (osThread(Thread), NULL);
  if(!tid_Thread) return(-1);
  
  return(0);
}

void Thread (void const *argument) {
  uint8_t led_state = 0x01;
  uint8_t but_current;
  uint8_t but_last;
  uint8_t but_changed;
  uint8_t but_num;
  uint16_t adc_val;
    
  while (1) {
    
    switch (gState) {  
  
      case DEV_IDLE:      
        break;
      
      case DEV_START_RECORD:  
        // hide logical unit        
        USBD_MSC0_SetMediaOwnerFS();       
        finit("M0:");      
        fmount("M0:");  
			  f_but = fopen("ButtonsLog.txt","a");
			  f_adc = fopen("AdcLog.txt","a");
        ADC_StartConversion();
        gState = DEV_RECORDING;
        break;
      
      case DEV_STOP_RECORD:    
				fclose (f_but);
			  fclose (f_adc);
        LED_SetOut(0);
        // show logical unit
        USBD_MSC0_SetMediaOwnerUSB();
        gState = DEV_IDLE;
        break;

      case DEV_RECORDING:    
        // Buttons sampling
        but_current = (Buttons_GetState());
        but_changed = but_current ^ but_last;
        but_last = but_current;
        but_num = 0;      
        while(but_changed) 
        {      
          if (but_changed&1) {
            LogButton(but_num,but_current&1);
          }        
          but_num++;      
          but_changed>>=1;
          but_current>>=1;                   
        }      
            
        // ADC sampling    
        if (ADC_ConversionDone() == 0) {
          adc_val = ADC_GetValue();
          LogADC(adc_val);              
        }
        ADC_StartConversion();
        
        // Toggle leds
        LED_SetOut(led_state);
        led_state = ~led_state;            
        break;                    
    }
    
    osSignalWait(0x01,osWaitForever);     
  }
}


