/*----------------------------------------------------------------------------
 * CMSIS-RTOS 'main' function template
 *---------------------------------------------------------------------------*/

#define osObjectsPublic                     // define objects in main module
#include "osObjects.h"                      // RTOS object definitions
#include "Board_Buttons.h"
#include "Board_LED.h"  
#include "Board_ADC.h"  
#include "rl_fs.h"

extern int Init_Thread (void);
extern void Init_Timers (void);

/*
 * main: initialize and start the system
 */
int main (void) {
  osKernelInitialize ();                    // initialize CMSIS-RTOS
	
  // initialize peripherals here
  Init_Timers();
	LED_Initialize();
	Buttons_Initialize();
	ADC_Initialize(); 
	finit  ("M0:");        
  fmount ("M0:");         

  // create 'thread' functions that start executing,
  // example: tid_name = osThreadCreate (osThread(name), NULL);
	Init_Thread();

	osKernelStart ();                         // start thread execution 
}
