% Priklad nacitania dat z binarneho suboru do prostredia Matlab

name = 'out.bin'  % meno binarneho suboru, ktory sa vygeneruje 
CNT = 10;         % pocet nacitavanych poloziek

fid = fopen( name, 'r' );     % 'r' -  citanie

%  Podporovane typy s roznou presnostou pre funkciu fwrite resp. fread
%  MATLAB    C or Fortran     Description
%  'uchar'   'unsigned char'  unsigned integer,  8 bits.
%  'schar'   'signed char'    signed integer,  8 bits.
%  'int8'    'integer*1'      integer, 8 bits.
%  'int16'   'integer*2'      integer, 16 bits.
%  'int32'   'integer*4'      integer, 32 bits.
%  'int64'   'integer*8'      integer, 64 bits.
%  'uint8'   'integer*1'      unsigned integer, 8 bits.
%  'uint16'  'integer*2'      unsigned integer, 16 bits.
%  'uint32'  'integer*4'      unsigned integer, 32 bits.
%  'uint64'  'integer*8'      unsigned integer, 64 bits.
%  'single'  'real*4'         floating point, 32 bits.
%  'float32' 'real*4'         floating point, 32 bits.
%  'double'  'real*8'         floating point, 64 bits.
%  'float64' 'real*8'         floating point, 64 bits.
%

out = fread( fid, CNT, 'uint8' );   % zapis vektora in do binarneho suboru 
                              % ako 8-bitove neznamienkove cisla

out                           % zobrazenie nacitanych hodnot