/*
; Demonstracny program pre citanie vysledkov AD prevodnika ADuC836EVB
; Po prekroceni definovanych prahov je zapinana LED diody a BZUCIAK
;
;
; Nazov podprogramu: ADCUART (jazyk C)
;
; Opis:
;
; Po definovanom oneskoreni sa meni logicka uroven na vyvodoch
; T0 a T1. Program je realizovany v nekonecnej slucke
;
; Autor:        M.Drutarovsky, TU Kosice
; Date:         19.11.2003
; Verzia:       0.1
; Poslena oprava: 19.11.2003 M.D.
*/

#include <stdio.h>              // <  > oznacuje hlavickove subory v systemovych adresaroch
#include <ADuC836.h>
#include "prevod.h"             // "  " oznacuje hlavickove subory projektu
#include "timer.h"              // funkcie pre oneskorenie


#define BZUCIAK T1
#define LED     T0                      // vyvod P3.4
#define POT_PRAH_ALARM          (1000)  // 1 V
#define POT_PRAH_CRITICAL       (2000)  // 2 V
#define LED_ON                     (1)  // pozri schemu zapojenia
#define LED_OFF                    (0)
#define BZUCIAK_ON                 (0)
#define BZUCIAK_OFF                (1)


bit press_INT0( void )
{
bit tmp;
        INT0 = 1;               // pre istotu zapiseme do vystupneho registra 1 (ideme citat z portu)
        do{
           tmp = INT0;          // precitanie aktualneho stavu tlacidla
           delay( 20 );
        }
        while( tmp != INT0 );   // testovanie moznych prekmitov tlacidla
        return tmp;             // vrati stav tlacidla 1=nestlacene, 0=stlacene
}

void main (void)
{
 int temp;

// UART config (s vyuzitim specialneho casovaca T3, ktory
// vyrazne rozsiruje moznosti ADuC 83x)

       T3CON = 0x82;
       T3FD = 0x12;
       SCON = 0x52;

        init_timer0();                            // inicializacia casovaca
        printf("_________________________________________\nAnalog Devices MicroConverter ADuC836 EVB\nAIN5 Reading Routine\n");
        printf("\Pokracovanie - Stlac tlacidlo INTO\n");

                while( press_INT0() )                    // caka na stalcenie tlacidla
                                ;
        printf("\OK - Tlacidlo INTO stlacene!\n");

        while(1)
        {
                temp = 10*read_pot();             // priblizny prepocet na mV
                if ( temp > POT_PRAH_ALARM )
                        LED = LED_OFF;            // vypnutie LEDky po prekroceni prahu1
                else
                        LED = LED_ON;
                if (temp > POT_PRAH_CRITICAL)
                        BZUCIAK = BZUCIAK_ON;
                else
                        BZUCIAK = BZUCIAK_OFF;

                printf("\b\b\b\b\b\b\b\b%4d mV ", temp);  // vypis vo vhodnom tvare
            delay( 200 );                         // oneskorenie 200 ms

        }
}
