/*
; timer.c
;
; Demonstracny program pre pouzitie casovaca a vystupu na port
;
; Opis:
;
;       Program ma vysielat na pin P3.4 (pripojene LED na EVB doske) obdlznikovy
;       signal s periodou 1s. Perioda je urcena casovacom T0 a sotverovym pocitadlom.
;       Casovac pracuje v rezime 1 t.j. ako 16 bitovy.
;
;       Nastavenie T0:
;
;       TMOD: GATE  C/T  M1  M0  GATE  C/T  M1  M0
;              X    X    X   X    0     0   0   1       mod 1 casovaca T0
;
;       TCON:  TF1  TR1  TF0  TR0  IE1  IT1   IE0  IT0
;               x    x   x    0/1   x    x     x    x   zapnutie/vypnutie casovaca T0
;
;       IE:     EA  ET2  ES  ET1  EX1  ET0  EX0
;               1    x   x    x    x    1    x          povolenie prerusenia od T0
;
;
;       V preruseni sa zmeni stav pinu p3.4 .
;
;       Zakladna perioda casovaca je 500 us, co pri frekvenii osc. 12MHz
;       vychadza na predvolbu T0: 65536-500=65036D
;       !!! startovaci kod nastavuje taktovanie jadra na frekvenciu
;           12,582912 MHz, pri presnych poziadavkach na casovanie
;           je potrebne uvazovat tuto hodnotu.
;           V pripade, ze v prostredi uVision by bol v projekte nastaveny
;           procesor ADuC836, simulator korektne simuluje aj obvody PLL.
;
;
;       timer0 - podprogram obsluhy prerusenia casovaca 0
;
;       main  - hlavny program, ktory inicializuje casovac,
;           po inicializacii v nekonecnej slucke realizuje
;
;
*/

#include <reg51.h>

#define PERIOD  (65536-500)     // definuje cas medzi preruseniami od T0
#define CNT          (2000)     // definuje poced "PERIOD" medzi zmenami LED

sbit LED = P3 ^ 4;

unsigned int pocitadlo;         // softverove pocitadlo (neznamienkove cislo),
                                // 16 bitov zabezpeci dostatocny rozsah

void timer0 (void) interrupt 1  // obsluha prerusenia casovaca 0
{
  TR0=0;                        // zastavenie casovaca T0
  TL0=PERIOD%256;               // definovanie periody
  TH0=PERIOD/256;
  TR0=1;                        // spustenie casovaca T0
  if( pocitadlo == 0) {         // testovanie podmienky ==0 je jednoduchsie ako == CNT
          LED = ~LED;           // negovanie signalu pre LEDku
      pocitadlo = CNT;
  }
  else
          pocitadlo--;          // bolo by mozne zapisat aj "uspornejsie"
}


//----------------------------------------------
// HLAVNY PROGRAM
//----------------------------------------------

void main (void)
{
  TMOD=0x01;                    // mod 1 casovaca T0
  IE=0x82;                      // povolenie prerusenia od T0 a golbalneho prerusenia
  TL0=PERIOD%256;               // definovanie periody prerusenia
  TH0=PERIOD/256;
  pocitadlo = CNT;              // inicializacia softveroveho pocitadla
  TR0=1;                        // spustenie casovaca

 while(1) {
        ;                       // tu moze prebiehat "uzitocna cinnost"
 }                              // hlavneho programu
}
