; Demonstracny program pre pouzitie casovaca a vystupu na port
;
; Nazov podprogramu: GEN1MS
;
; Opis:
;
; Program vysiela na pin P3.4 (na vyvod T0 EVB dosky je pripojena LEDka)
; obdlznikovy signal s periodou priblizne 1 ms. Perioda je urcena
; citacom/casovacom T0.
; Casovac T0 pracuje v rezime 1 t.j. ako 16 bitovy.
;
;       Nastavenie T0:
;
;       TMOD: GATE  C/T  M1  M0  GATE  C/T  M1  M0
;               X    X    X   X    0    0    0  1       mod 1 casovaca T0
;
;       TCON:  TF1  TR1  TF0  TR0  IE1  IT1   IE0  IT0
;               x    x   x    0/1   x    x     x    x   zapnutie/vypnutie
;                                                       casovaca T0
;
;       IE:     EA  ET2  ES  ET1  EX1  ET0  EX0
;               1    x   x    x    x    1    x          povolenie prerusenia
;                                                       od casovaca T0
;
;       Vektor prerusenia casovaca T0 je na adrese 000Bh.
;       V preruseni sa zmeni stav pinu p3.4
;
;       Zakladna perioda casovaca je 500 us, co pri frekvenii osc. 12MHz
;       vyzaduje predvolbu T0: 65536-500=65036 (dekadicky)
;
;
;       OBST0 - podprogram obsluhy prerusenia casovaca 0
;
;       MAIN  - hlavny program, ktory po inicializacii casovaca T0
;               inkrementuje obsah akunulatora v nekonecnej slucke
;               (demonstruje cinnost, ktoru moze procesor realizovat,
;               pricom "na pozadi" prebieha ovladanie LED diody)
;
; Autor:        M.Drutarovsky, TU Kosice
; Date:         02.11.2003
; Verzia:       1.01


#include "reg51.inc"            ; hlavickovy subor s definiciami SFR a SBIT

        ORG 0                   ; zaciatok programu po resete procesora

        JMP MAIN                ; "obskocenie" vektorov preruseni

        ORG 000BH               ; vektorova addr prerusenia od citaca/casovaca T0
        JMP OBST0               ; odskok na obsluzny podprogram prerusenia

;----------------------------------------------
; HLAVNY PROGRAM
;----------------------------------------------

        ORG 100H

MAIN:
        CALL INI_T0             ; pociatocne nastavenie a start casovaca T0

        CLR  A                  ; inicializacia ACC
KONIEC:
        INC  A                  ; "cinnost v hlavnom programe"
        JMP KONIEC              ; koniec (nekonecna slucka)

;----------------------------------------------
; PODPROGRAMY
;----------------------------------------------


INI_T0:                         ; inicializacia casovaca T0

        MOV TMOD,#00000001B     ; mod 1
        ORL IE  ,#10000010B     ; povolenie prerusenia od T0
        MOV TH0,#HIGH(65036)    ; inicializacia predvolby
        MOV TL0,#LOW(65036)
        SETB TR0                ; spustenie casovaca T0
        RET

;----------------------------------------------

OBST0:
        CLR TR0                 ; zastavenie casovaca T0 (preco?)
        MOV TH0,#HIGH(65036D)   ; obnova predvolby
        MOV TL0,#LOW(65036D)
        SETB TR0                ; spustenie casovaca
        CPL P3.4                ; zmena stavu pinu (LED diody na EVB doske)
        RETI                    ; navrat z prerusenia

        END