; Demonstracny program pre ovladanie portov MCU-51
;
; Popis:
;
;       DELAY - podprogram pre softverove oneskorenie
;       OUTP1 - podprogram pre vyslatie bajtu z adresy @R0 na 
;               port P1
;       MAIN  - hlavny program, ktory vysiela na port P! sekvenciu
;               bajtov ulozenych vo vnutormej RAM od adresy @R0
;               s dlzkou R4
;       
;
;
; Program nici: A,
;
; Autor:        E.Matus, TU Kosice      
; Date:         06.11.98
; Verzia:       1.0
; Poslena oprav:06.11.98


; definicie

N       EQU     11D     ; POCET BYTE V BLOKU


        ORG 0           ; PO RESETE

        JMP MAIN

;----------------------------------------------
; HLAVNY PROGRAM
;---------------------------------------------- 
        
        ORG 100H

MAIN:   
        MOV DPTR,#TAB1  ; INICIALIZACIA - ADRESY ZACIATKU TABULKY
        MOV R4,#N       ; INICIALIZACIA - POCET BYTE
        MOV R0,#0       ; INNICIALIZACIA INDEXU DO TAB
                
STAR1:  CALL OUTP1      ; Vyslatie bajtu z adr @R0 na port P1
        CALL DELAY      ; Oneskorenie
        INC R0          ; INKREMENT SMERNIKA
        DJNZ R4,STAR1   ; FOR SLUCKA
        
        JMP MAIN        ; OD ZACIATKU

;----------------------------------------------
; PODPROGRAMY
;----------------------------------------------

;----------------------------------------------

OUTP1:
        PUSH ACC
        MOV  A,R0       ; SET - INDEX V TABULKE
        MOVC A,@A+DPTR  ; CITANIE BAJTU Z TABULKY V P. PROGRAMU
        MOV  P1,A       ; VYSLATIE NA PORT
        POP  ACC
        RET             ; NAVRAT Z PODPROGRAMU

;----------------------------------------------


DELAY:
        PUSH ACC        ; ODLOZ AKUMULATOR

        MOV R3,#10D
DEL3:   MOV R2,#100D
DEL2:   MOV R1,#50D     ; 1 CYKLUS
DEL1:   DJNZ R1,DEL1    ; D1=R1*(2 CYKLY)       
        DJNZ R2,DEL2    ; D2=R2*(2C+1C+D1)
        DJNZ R3,DEL3    ; R3*(2C+1C+D2)

        POP ACC         ; OBNOV AKUMULATOR
        RET

TAB1:   DB      11111111B   ; TABULKA
        DB      11111110B
        DB      11111100B
        DB      11111001B
        DB      11110011B
        DB      11100111B
        DB      11001111B
        DB      10011111B
        DB      00111111B
        DB      01111111B
        DB      11111111B


        END