; Demonstracny program pre kopirovanie ASCII retazca z pamate
; programu do vnutornej RAM
; Dlzka retazca je kontrolovana koncovym znakom 00H
; Program vyuziva direktivy na alokaciu segmentov v roznych
; pamatiach 8051
;
; Nazov podprogramu: MOVCSTR
;
; Opis:
;
; ASCII retazec je ulozeny v pamati programu od adresy AS
; (je tam teda vzdy po zapnuti napajania a starte procesora)
; a je ukonceny kodom 00H
; Z adresy AS v CODE pamati sa presunie na adresu AD vo vnutornej (DATA) RAM.
; Nech: AS - je v registri DPTR
;       AD - je v registri R1
;
;
; Autor:        E.Matus, TU Kosice
; Date:         22.10.1998
; Verzia:       1.2
; Oprava:       25.10.2003 M.D. (prisposobene pre Keil A51, dodany kod)
;               04.11.2004 M.D. (dodany kod na alokaciu v XDATA pamati)
;                               Tento kod bol dodany na demonstraciu sposobu
;                               alokacie externej RAM pamate, ktory je potrebne
;                               treba pouzit v dalsich prikladoch resp. domacich ulohach.
;                               Kedze obsah XDATA pamate (podobne DATA, IDATA) nie je
;                               po resete procesora definovany, inicializaciu musi
;                               to zabezpecit aplikacia
;               2007-10-25 M.D. uprava komentarov
;               2008-10-27 M.D. uprava komentarov
;


; definicie

#include "reg51.inc"    ; hlavickovy subor s definiciami SFR a SBIT

VAR1    SEGMENT XDATA   ; definicia segmentu v XDATA pamati
                        ; (v tomto priklade nepotrebne, vyuzitelne v domacej ulohe)

AS      EQU     1000H   ; ZACIATOK retazca (v CODE pamati)
AD      EQU     30H     ; CIELOVA adresa retazca (v DATA pamati)

        USING   0       ; definuje hodnoty absolutnych adries AR0-AR7
                        ; (0 - zodpoveda banke 0)
                        ; direktiva USING zabezpeci automaticke generovanie
                        ; adries AR0-AR7, ktore prisluchaju zvolenej banke
                        ; registrov (AR0 je absolutna adresa registra R0
                        ; v aktualne zvolenej banke, t.j. 00h pre banku 0,
                        ; 08h pre banku 1, ...).
                        ; !!! direktiva USING nezabezpeci natavenie prislusnej
                        ; banky registrov v PSW. Toto musi zabezpecit
                        ; vhodnou modifikaciou registra PSW.
                        ; Po resete je v PSW nastavena banka registrov 0:
; Program Status Word (PSW)
; addr    PSW:  CY  AC  F0  RS1 RS0  OV  -  P   Reset 
; 90H            x   x   x   x   x    x  x  x   0x00
;                            0   0              Banka 0
;                            0   1              Banka 1
;                            1   0              Banka 2
;                            1   1              Banka 3
; 


        ORG 0           ; zaciatok programu PO RESETE
        jmp     START
;----------------------------------------------
; HLAVNY PROGRAM
;----------------------------------------------

        ORG     100h
START:  MOV DPTR,#AS    ; zdrojova adresa zaciatku retazca v CODE pamati
        MOV R1,#AD      ; cielova adresa retazca v DATA pamati
        CALL MOVCSTR    ; volanie podporogramu kopirovania

        MOV DPTR,#ADR2  ; len na demonstrovanie hodnoty ADR2
                        ; (vidno napr. v simulatore), umoznuje
                        ; alokovat presnu polohu v XDATA pamati.

KONIEC: JMP KONIEC      ; koniec (nekonecna slucka)

;----------------------------------------------
; PODPROGRAMY
;----------------------------------------------
MOVCSTR:
; pouziva;    A, R0, R1, DPTR
; uchovava;   A, R0
; nici:       R1, DPTR
; zasobnik:   2 bajty

        PUSH ACC                ; odlozenie akumulatora (ACC je adresa akumulatora v oblasti SFR,
                                ; instrukcia PUSH A neexistuje!!!)
        PUSH AR0                ; odlozenie R0 v banke definovanej
                                ; direktivou USING (AR0 je absolutna adresa
                                ; R0 v DATA pamati, instrukcia PUSH RO neexistuje!!! )
        MOV R0,#0               ; inicializacia "indexu" prvku v kopirovanom
                                ; retazci, ktory zacina na adrese AS v CODE pamati

MVS:    MOV  A,R0               ; kopia "indexu" do A
        MOVC A,@A+DPTR          ; nacitanie zdrojoveho bajtu retazca
        MOV @R1,A               ; presun bajtu priamo do DATA pamate
        INC R0                  ; inkrementacia "indexu"
        INC R1                  ; inkrementacia cielovej adresy (smernika)
        CJNE A,#00H,MVS         ; test ukoncenia (konca retazca)
        POP AR0                 ; obnova R0
MVSEND: POP ACC                 ; obnova akumulatora
        RET                     ; navrat z podprogramu

;----------------------------------------------
; Retazec v extrenej programovej pamati
; (je ulozeny trvale, teda po resete procesora je okamzite k dispozicii)
;----------------------------------------------
        ORG     AS
        DB      'R'             ; retazec v programovej ("CODE") pamati
        DB      'E'
        DB      'T'
        DB      'A'
        DB      'Z'
        DB      'E'
        DB      'C'
        DB      00h             ; zakonceny nulou (umoznuje ukoncit podprogram kopirovania)

        RSEG    VAR1            ; priklad alokacie priestoru v XDATA pamati
        ORG     1000H           ; definovanie polohy v adresovom priestore
ADR1:   DS      20              ; ADR1 ma hodnotu 1000H
ADR2:   DS      30              ; ADR2 ma hodnotu 1014H

        END