function ext = mexext(platform)
%MEXEXT Returns the MEX file name extention.
%       EXT = MEXEXT(PLATFORM) returns the file name extension for the
%       given PLATFORM.  If no PLATFORM is given, the current platform is
%       used.
%
%       Note that the PLATFORM argument must be the same as the output
%       string from the function COMPUTER for the platform of interest.

%       P. Barnard 1-11-95
%       Copyright (c) 1995 The MathWorks, Inc.
%       $Revision: 1.4 $  $Date: 1995/05/08 20:55:16 $

% Set the platform equal to the current platform if none is given.
if nargin < 1
   platform = computer;
end

% For the PC and MAC platforms.
if strcmp(platform, 'PCWIN') | strcmp(platform, 'MAC2')
   ext = 'mex';

% For the SUN4
elseif strcmp(platform, 'SUN4')
   ext = 'mex4';

% For the LNX86
elseif strcmp(platform, 'LNX86')
   ext = 'mexlx';

% For the SOL2
elseif strcmp(platform, 'SOL2')
   ext = 'mexsol';

% For the ALPHA running OSF
elseif strcmp(platform, 'ALPHA')
   ext = 'mexaxp';

% For the ALPHA running VMS
elseif strcmp(platform, 'AXP_VMSG')
   ext = 'mexag';

% For the HP700
elseif strcmp(platform, 'HP700')
   ext = 'mexhp7';

% For the HP300
elseif strcmp(platform, 'HP300')
   ext = 'mexhp3';

% For the IBM_RS
elseif strcmp(platform, 'IBM_RS')
   ext = 'mexrs6';

% For the SGI
elseif strcmp(platform, 'SGI')
   ext = 'mexsg';

% For the DEC_RISC
elseif strcmp(platform, 'DEC_RISC')
   ext = 'mexds';

% For the VAX_VMSD
elseif strcmp(platform, 'VAX_VMSD')
   ext = 'mexd';

% For the VAX_VMSG
elseif strcmp(platform, 'VAX_VMSG')
   ext = 'mexg';

% For the CRAY or CONVEX
elseif strcmp(platform, 'CRAY') | strcmp(platform, 'CONVEX')
   error('MEX files not supported for this platform.');
   ext = '';

% If the platform is not recognized
else
   error(['Platform ' platform ' not recognized.']);

end
