function Hout = makecopy(h,parent)
%MAKECOPY Make copy of HG object and parent it.
%	HH = MAKECOPY(H,P) makes a new object HH that is the same as H
%	except that it has the parent P.

%	This is a work around to a bug in copyobj.

%	Copyright (c) 1984-94 by The MathWorks, Inc.
%	$Revision: 1.5 $  $Date: 1995/01/17 13:42:57 $


lineprops = str2mat('Color','EraseMode','LineStyle','LineWidth', ...
   'MarkerSize','ButtonDownFcn','Clipping','Interruptible','Tag','Visible');
surfprops = str2mat('EdgeColor','EraseMode','FaceColor','LineStyle', ...
  'LineWidth','MarkerSize','MeshStyle','Clipping','Interruptible',...
  'Tag','Visible');
patchprops = str2mat('EdgeColor','EraseMode','FaceColor', ...
  'Clipping','Interruptible','Tag','Visible');
textprops = str2mat('Color','EraseMode','FontAngle','FontName','FontSize', ...
  'FontStrikeThrough','FontUnderline','FontWeight','HorizontalAlignment');
textprops = str2mat(textprops,'Position','Rotation','Units', ...
           'VerticalAlignment','Clipping','Interruptible','Tag','Visible');

h = h(:);
len = length(h);
hh = zeros(len,1);
for k=1:len,
   hh(k) = copyobj(h(k));
   set(hh(k),'Parent',parent)

   Type = get(hh(k),'Type');
   if strcmp(Type,'line'),
     props = lineprops;
   elseif strcmp(Type,'surface'),
     props = surfprops;
   elseif strcmp(Type,'patch'),
     props = patchprops;
   elseif strcmp(Type,'text'),
     props = textprops;
   else
     error(['Unknown object type: ' Type])
   end

   for i=1:size(props,1),
     set(hh(k),props(i,:),get(h(k),props(i,:)))
   end
end
if nargout,
   Hout = hh;
end

% end makecopy

