    function string = timedate()

%-----------------------------------------------------------------------------
%    Initialize variables
%-----------------------------------------------------------------------------
    months = ['Jan';'Feb';'Mar';'Apr';'May';'Jun';
              'Jul';'Aug';'Sep';'Oct';'Nov';'Dec'];
    
%-----------------------------------------------------------------------------
%    prepare timestring
%-----------------------------------------------------------------------------

    clockstring = clock;

    year    = num2str(clockstring(1));
    month   = months((clockstring(2)),:);
    day     = num2str(clockstring(3));
    hours   = num2str(clockstring(4));
        if clockstring(5) <= 9   % place a leading zero if needed
      minutes = ['0' num2str(clockstring(5))];
        else
      minutes = num2str(clockstring(5));
        end;
    seconds = num2str(clockstring(6));

%-----------------------------------------------------------------------------
%    Verify Outputs
%-----------------------------------------------------------------------------
    

        string = [day '-' month '-' year ', ' hours ':' minutes ];
        %string = [hours '.' minutes ' Uhr, ' day '. ' month ' ' year];
    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END FUNCTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Revision History
%
% 15. Jan 1996  Timedatestring first written;
% filename: timedatestring.m
% rev.date: 15. Jan 96
% class:    function
%
% PURPOSE:  returns a string containing date and time in a pleasing notation
%           
%
% USAGE: string = datetimestring
%
%        
% OUTPUT: string = string with time and date, e.g. '15.05 Uhr, 15.01.96'
%                  
% written on: 15 Jan 1996
% written by: Uwe Petersen
%                                                                             
%      /\       Uwe Petersen                                                 
%     /  \                                                                  
%  /\ \  /      Institute B of Mechanics                                   
% /  \ \/ /\    University of Stuttgart                                       
% \  /   /  \   Pfaffenwaldring 9           Phone: +49 (711) 685-6391         
%  \/ /\ \  /   70550 Stuttgart             Fax:   +49 (711) 685-6400         
%    /  \ \/    Germany                     Email: pu@mechb.uni-stuttgart.de  
%    \  /                                                                    
%     \/                                                                     
%_____________________________________________________________________________
%
% Adapted By: Mehmet Zeytinoglu 
% Adapted On: September 1996, shortened name to "timedate.m" for conformity 
%
%    $Revision: 1.3 $   $Date: 1997/03/11 16:18:10 $
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF FUNCTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

