function [b, a] = lat2poly( arg1, arg2 )
%LAT2POLY Compute polynomial coefficients from reflection coefficients.
%        [B,A] = LAT2POLY( K, C ) finds the filter coefficients B and A, 
%        with A(1) == 1, from the real reflection coefficients K and real
%        "C"-coefficients C of the FIR/IIR lattice structure of a discrete
%        filter.
%
%        For an FIR filter A = 1; for an ALL-POLE IIR filter B = 1.
%        For IIR filters A is a row vector of length one more than K.
%        For FIR filters one can omit the "C"-array using the form
%        [B,A] = LAT2POLY( K ).
%
%        See also POLY2LAT.

%
%    adapted from the Mathworks M-file "rc2poly" by T. Krauss, 9-20-93
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

if ( length(arg2) == 2 )        % ==== FIR ====
   k = arg1;
   c = zeros(1,length(k)+1);
   g = arg2(1);
   type  = 1;
elseif ( arg2 == 1 )            % ==== IIR: (all-pole)  ====
   k = arg1;
   c = zeros(1,length(k)+1);
   type  = 2;
else                            % ==== IIR: (pole+zero) ====
   k = arg1;
   c = arg2;
   type  = 3;
end

b = c;
a = k(1);

for i = 2:length(k)
    b(1:i-1) = b(1:i-1) + c(i)*a(length(a):-1:1);
           a = [ a+a(i-1:-1:1)*k(i)  k(i) ];
end 

b(1:i) = b(1:i) + c(i+1)*a(length(a):-1:1);

if ( type == 1 )
   b = [g+arg2(2) arg2(2)*a];
   a = 1;
elseif ( type == 2 )
   b = 1;
   a = [1 a];
elseif ( type == 3 )
   a = [1 a];
end
