function  [ Nkai, beta ] = kaiseord(  fre, dev, fs );
%KAISEORD estimates the order of a windowed Kaiser FIR filter
%    [ Nkai, beta ] = kaiseord(  fre, dev, fs )

%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

        alfa = -min(20*log10(dev));
        if alfa > 50,
            beta = .1102*(alfa - 8.7);
        elseif alfa >= 21,
            beta = .5842*((alfa-21).^(.4)) + .07886*(alfa-21);
        else
            beta = 0;
        end
        Nkai = ceil((alfa - 8)/(2.285*(fre(2)-fre(1))*pi/(fs/2)));
