function s=int2oct(d,n)
%INT2OCT Convert integer to an octal string.
%
%       INT2OCT(D) returns the octal representation of D as a string.
%       D must be a non-negative integer.  For example, INT2OCT(31)
%       returns '037'.
%
%       INT2OCT(D,N) produces an octal representation with at least
%       N octal digits. For example, INT2OCT(31,4) returns '00037'.
%

%
%    adapted from Hans Olsson's DEC2BIN
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

if (nargin<2) n=1; end; % Need at least one digit even for 0.
[f,e] = log2(max(d));
e = max(n,ceil(e/3));   % e=log8(max(d)) How many digits to represent the number
s = sprintf('%X',rem(floor(d(:)*pow2(3*(1-e:0))),8)');
s = [ setstr(ones(length(d),1)*'0')';  reshape(s,[e length(d)]) ]';

