function s=int2hex(d,n)
%INT2HEX Convert integer to a hexadecimal string.
%
%       INT2HEX(D) returns the hexadecimal representation of D as a string.
%       D must be a non-negative integer.  For example, INT2HEX(31)
%       returns '0x17'.
%
%       INT2HEX(D,N) produces a hexadecimal representation with at least
%       N hexadecimal digits. For example, INT2HEX(31,4) returns '0x0017'.
%
%       INT2HEX differs from DEC2HEX by the leading string '0x' and by 
%       non-suppressed leading '0's.

%
%    adapted from Hans Olsson's DEC2BIN
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

if (nargin<2) n=1; end; % Need at least one digit even for 0.
[f,e] = log2(max(d));
e = max(n,ceil(e/4)); %e=log16(max(d)) How many digits to represent the numbers?
s = sprintf('%x',rem(floor(d(:)*pow2(4*(1-e:0))),16)');
s = [ setstr(ones(length(d),1)*['0' 'x'])';  reshape(s,[e length(d)]) ]';

