function [h , denum]=firlsa(N,F,M,W);
% FIRLSA Linear-phase FIR filter design using least-squares error minimization
%        [B,A]=FIRLSA(N,F,M) returns a length N+1 linear phase (real, symmetric
%        coefficients) FIR filter in B and A=1.  This is a simple wrapper 
%        around the Mathworks Signal Processing Toolbox function FIRLS such 
%        that there is consistency in the way all Matlab FIR design functions 
%        behave.
%
%        All the MATLAB FIR design functions return both the numerator and the
%        denominator polynomials.  For example, [B,A]=remez(...) would return
%        A=1.  The only exception was the FIRLS function, so I wrote FIRLSA.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $    
%

h = firls(N,F,M,W);
denum = 1;
