function dfp()
%DFP initialization function for the DIGITAL FILTER PACKAGE (DFP)
%
%    This function initialized the global variables, reads the user 
%    preferences if the file DFPRC.M exists, creates all the windows
%    except (PROPERTIES), sets their visible properties to off.   
%    When all the figures are created, it makes the "NAVIGATOR" window
%    visible.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

d_global;

fprintf('\n');
fprintf('    ===================================================\n');
fprintf('                Digital Filter Package (DFP)           \n');
fprintf('                      Version: %s\n', DFP_ver );
fprintf('    ===================================================\n');
fprintf('     Department of Electrical and Computer Engineering \n');
fprintf('              Ryerson Polytechnic University           \n');
fprintf('                 Toronto, Ontario, CANADA              \n');
fprintf('    ===================================================\n\n');

fprintf('    Initializing:\n')

fprintf('\t\tGlobal variables read.\n');
if ( exist('dfprc') )
    dfprc;
    fprintf('\t\tUser preferences read.\n');
end

fprintf('\t\tDFP navigator .................. ');
d_navgtr;
                                fprintf('done\n');

fprintf('\t\tDFP type/specifications ........ ');
d_tspint;
                                fprintf('done\n');
d_tspsup(1);

fprintf('\t\tDFP method ..................... ');
d_mtdint;
                                fprintf('done\n');

fprintf('\t\tDFP display .................... ');
d_disply;
                                fprintf('done\n');

fprintf('\t\tDFP form/coefficient ........... ');
d_recoef;
                                fprintf('done\n');

fprintf('\t\tDFP output ..................... ');
d_output;
                                fprintf('done\n');

d_navgcb( 0 );
