function s=dec2bin(d,n)

% DEC2BIN Convert integer to a binary string.
%
%       DEC2BIN(D) returns the binary representation of D as a string.
%       D must be a non-negative integer.  For example, DEC2BIN(23)
%       returns '10111'.
%
%       DEC2BIN(D,N) produces a binary representation with at least
%       N bits.

% Author: Hans Olsson from Lund, Sweden

%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%



if (nargin<2) n=1; end; % Need at least one digit even for 0.
[f,e]=log2(max(d));     % How many digits do we need to represent the numbers?
s=setstr(rem(floor(d(:)*pow2(1-max(n,e):0)),2)+'0');

