% filename: dateme.m
% rev.date: 3/30/95
% class:    function
%
% PURPOSE:  Applies the current date to the upper right corner 
%           of a figure window.
%
% USAGE: [dateax, datetxt] = dateme( fig )
%
%        "dateme" will add today's date to current figure window
%        "dateme off" will hide all dateme dates in the c.f.w.
%        "dateme on" will show any hidden dateme dates in the
%                    c.f.w., or add the date if none exists yet.
%        "dateme( X )" will add dates to all the figures whos
%                      handles are given in vector X
%        
% OUTPUT: dateax = the axes handle of the invisible axes on
%                  which the date text is placed (optional)
%         datetxt = the text handle of the datetext itself 
%         (optional: but given only one output argument,
%                    dateax will be returned, not datetxt)
%
% NOTE: the invisible date axes will have userdata 'dateaxes'
%        the text string will have userdata 'datetext'
%
% written on: 8 Feb 1995
% written by: Kevin G. Kohrt

% Permission granted to include DATEME or some variation of it
% with any other script(s), as long no part of this comment section 
% is deleted or changed (excluding the Rev.Date, Filename, & Class). -KGK
%
% Adapted By: Uwe Petersen
% Adapted On: 15. Jan 1996
%             The string containing the date was modified to now contain
%             time and date in German Notation.
%             Therefore, the function timedatestring.m is called, which
%             returns time and date , i.e. '16.54 Uhr, 15. Jan 1996'. The 
%             variable name datetext is kept.
%             Additionally, the position of the string within the axis is 
%             changed (moved downwards) accordingly.
%
%             Make the old axes the current axes again, after function is 
%             executed
%           
% Adapted By: Mehmet Zeytinoglu
% Adapted On: September 1996
%             Changed the call to "timedatestring.m" to the shortened
%             function "timedate.m"
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF FUNCTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    function [dateax, datetxt] = dateme( fig )

%-----------------------------------------------------------------------------
%    Verify inputs
%-----------------------------------------------------------------------------
    if nargin < 1;         
        fig = gcf;
    else;    
        if isstr('fig');
            datehand = findobj( gcf, 'UserData', 'datetext' );
            if strcmp( lower(fig), 'off' ) & ~isempty( 'datehand' )
                set( datehand, 'visible', 'off' ); return;
            elseif strcmp( lower(fig), 'on' )
                if isempty( datehand )
                    fig = gcf;
                else
                    set( datehand, 'visible', 'on' ); return;
                end
            else
                error('Could not apply command; ''on'' or ''off'' expected')
            end;
        else
            fig = fig( : );
        end;
    end;
%-----------------------------------------------------------------------------
%    Initialize variables
%-----------------------------------------------------------------------------
    datehand1    = zeros( size( fig ) );
    datehand2     = datehand1;
%-----------------------------------------------------------------------------
%    Apply the current date to all figures listed 
%-----------------------------------------------------------------------------
    for idx = 1 : length( fig )
      figure( fig( idx ) );
      oldunits = get( gcf, 'Units' );
          % store old axes
          oldaxes = (gca);
      set( gcf, 'Units', 'normalized' )
%Org  datehand1( idx ) = axes(  'Visible', 'off', 'UserData', 'dateaxes',...
%Org                            'Position', [ .95 .7.01 .01] ); 
      datehand1( idx ) = axes(  'Visible', 'off', 'UserData', 'dateaxes',...
                                'Position', [ .95 .55 .01 .01] ); 


%Org datehand2( idx ) = text(  'Units','data', 'Position', [ 0.1, 0.7 ],...
%Org                          'String', date, 'Rotation', 90,...
%Org                          'Userdata', 'datetext' );
  datehand2( idx ) = text(  'Units','data', 'Position', [ 0.1, 0.7 ],...
                           'String', timedate, 'Rotation', 90,...
                            'Userdata', 'datetext' );
      set( datehand2( idx ),...
            'Fontsize',     10,...
            'FontWeight',     'normal',...
            'ButtonDownFcn','moveobj',...
            'UserData',        'datetext' );
      set( gcf, 'Units', oldunits )
          % rechoose old axes
          axes(oldaxes)
    end;
%-----------------------------------------------------------------------------
%    Verify Outputs
%-----------------------------------------------------------------------------
    if nargout > 0;            dateax  = datehand1;            end;
    if nargout > 1;            datetxt = datehand2;            end
    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END FUNCTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Revision History
%
% 02/08/95  Dateme first written; includes multiple figures, handle returns,
%            and I/O verification.
%
% 03/27/95  Input can now be string 'off' or 'on' to make existing datetext
%            invisible or visible again.
% 03/30/95  "dateme on" debugged so that it will add a date if one does not
%           yet exist


