function d_tspsup( FiltTypeNumber )
%D_TSPSUP prepares the "TYPE and SPECIFICATIONS" window for different
%         filter types.
%
%         D_TSPSUP( FiltTypeNumber ) creates (or more accurately un-hides)
%         the labels and editable text objects for the filter specifications
%         corresponding to the FiltTypeNumber (FiltTypeNumber=1 -> LPF etc)
%         The entries in the editable text fields are the present values
%         of the filter parameters, which the user can change as required.
%
%         D_TSPSUP with no input arguments determines the FiltTypeNumber
%         from the pop-up-menu in the "TYPE and SPECIFICATIONS" window.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

FIG2han = findobj(get(0,'children'),'flat','Tag','fig2');
CHLDhan = get(FIG2han,'Children');
TXhan   = sort(findobj(CHLDhan,'flat','Type','uicontrol','Style','text'));
FRhan   = sort(findobj(CHLDhan,'flat','Type','uicontrol','Style','frame'));
EThan   = sort(findobj(CHLDhan,'flat','Type','uicontrol','Style','edit'));

if ( nargin < 1 )

   FiltTypeNumber = get(findobj(CHLDhan,'flat','Style','popupmenu'),'Value');

end


%=======================================================================
%  These cases deals with the individual filter specifications
%  Note that FRindex, TXindex, ETindex show which of the FR,TX.ET
%  objects will be visible for each filter type, respectively.  
%  The entry "0" in a particular object index position indicates
%  that particular object will have its "VISIBLE" property set to "off".
%=======================================================================

if ( FiltTypeNumber == 1 )  % LPF

    FRindex = [ 1 2 3 0 0 6 ];
    TXindex = [ 1 2 3 4 5 0 0 0 ];
    ETindex = [ 1 2 3 4 5 0 0 0 ];
    TXstr   = str2mat( ...
                      'Sampling Frequency',        ...
                      'Passband Edge' ,            ...
                      'Passband Attenuation (dB)', ...
                      'Stopband Edge' ,            ...
                      'Stopband Attenuation (dB)'  ...
                      );

elseif ( FiltTypeNumber == 2 )  % HPF

    FRindex = [ 1 2 3 0 0 6 ];
    TXindex = [ 1 2 3 4 5 0 0 0 ];
    ETindex = [ 1 2 3 4 5 0 0 0 ];
    TXstr   = str2mat( ...
                      'Sampling Frequency',        ...
                      'Stopband Edge' ,            ...
                      'Stopband Attenuation (dB)', ...
                      'Passband Edge' ,            ...
                      'Passband Attenuation (dB)'  ...
                      );

elseif ( FiltTypeNumber == 3 )  % BPF

    FRindex = [ 1 2 0 4 5 6 ];
    TXindex = [ 1 2 3 4 5 6 7 8 ];
    ETindex = [ 1 2 3 4 5 6 7 8 ];
    TXstr   = str2mat( ...
                      'Sampling Frequency',              ...
                      'First Stopband Edge' ,            ...
                      'First Stopband Attenuation (dB)', ...
                      'First Passband Edge' ,            ...
                      'Passband Attenuation (dB)',       ...
                      'Second Passband Edge' ,           ...
                      'Second Stopband Edge' ,           ...
                      'Second Stopband Attenuation (dB)' ...
                      );

elseif ( FiltTypeNumber == 4 )  % BSF

    FRindex = [ 1 2 0 4 5 6 ];
    TXindex = [ 1 2 3 4 5 6 7 8 ];
    ETindex = [ 1 2 3 4 5 6 7 8 ];
    TXstr   = str2mat( ...
                      'Sampling Frequency',              ...
                      'First Passband Edge' ,            ...
                      'First Passband Attenuation (dB)', ...
                      'First Stopband Edge' ,            ...
                      'Stopband Attenuation (dB)',       ...
                      'Second Stopband Edge' ,           ...
                      'Second Passband Edge' ,           ...
                      'Second Passband Attenuation (dB)' ...
                      );

elseif ( FiltTypeNumber == 5 )  % Differentiator

    FRindex = [ 1 2 3 0 0 6 ];
    TXindex = [ 1 2 3 4 5 0 0 0 ];
    ETindex = [ 1 2 3 4 5 0 0 0 ];
    TXstr   = str2mat( ...
                      'Sampling Frequency',              ...
                      'Type III/IV filter (even/odd order)', ...
                      'Peak relative error (dB)',        ...
                      'Cut-off frequency',               ...
                      'Slope (greater than O)'           ...
                      );

elseif ( FiltTypeNumber == 6 )  % Hilbert

    FRindex = [ 1 2 3 0 0 6 ];
    TXindex = [ 1 2 3 4 5 0 0 0 ];
    ETindex = [ 1 2 3 4 5 0 0 0 ];
    TXstr   = str2mat( ...
                      'Sampling Frequency',              ...
                      'Type III/IV filter (even/odd order)', ...
                      'Peak error (dB)',                 ...
                      'Lower Edge Frequency',            ...
                      'Upper Edge Frequency'             ...
                      );

end

%==================================================================
%  Now the FRinde/TXindex/ETindex/TXstr have been set up correctly
%  for each FILTER TYPE.   Let us modify them accordingly.
%==================================================================
%  INDEX is an array that represents the objects which will
%  be VISIBLE.  Determine INDEX separately for each object group.
%=================================================================

index = (FRindex == [1:length(FRhan)]); ...       % FRAME objects
        set( FRhan( index),'Visible','on'  ); ...
        set( FRhan(~index),'Visible','off' );

index = (TXindex == [1:length(TXhan)]); ...       % TEXT objects
        set( TXhan( index),'Visible','on'  ); ...
        set( TXhan(~index),'Visible','off' );

index = (ETindex == [1:length(EThan)]); ...       % EDITABLE TEXT objects
        set( EThan( index),'Visible','on'  ); ...
        set( EThan(~index),'Visible','off' );
        %===========================================
        %  Read FIG2 Userdata and extract the part
        %  corresponding to the selected Filter type
        %===========================================
        ETdata = get( FIG2han, 'Userdata' );
        ETdata = ETdata(FiltTypeNumber,1:sum(index));


for ii = TXindex(TXindex == [1:length(TXhan)])
    set( TXhan(ii), 'String', deblank(TXstr(ii,:)) );
end

for ii = ETindex(ETindex == [1:length(EThan)])
    set( EThan(ii), 'String', sprintf(' %g',ETdata(ii)) )
end
