function FIGhan = d_tspint()
%D_TSPINT creates and initializes the "TYPE and SPECIFICATIONS" window 
%         and its children.
%
%         FIG = D_TSPINT returns the handle to the figure object which has 
%         been created by calling the function D_TSPINT.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

%=================
% GLOBAL variables
%=================
global   DFP_ETbgroundcolor  DFP_WinBorderOffset  DFP_Frame2button    ...
         DFP_UIcontrolBox_X  DFP_UIcontrolBox_Y   DFP_Offset3         ...
         DFP_initial         DFP_FigureResize     DFP_UIbgroundcolor  ...
         DFP_ScaleX          DFP_ScaleY

%==============
% FIGURE NUMBER
%==============
FigNo = 2;

%==============================
% Dimension definitions (local)
%==============================
Dim1  = 1;                  % FR to l/r FIG edge
Dim2  = 1;                  % FR to b FIG edge
Dim21 = DFP_Frame2button;   % FR to t FIG edge
Dim3  = DFP_Frame2button;   % UI to l/r FR  edge
Dim4  = DFP_Frame2button;   % UI to b/t FR  edge
Dim41 = 20 * DFP_ScaleY;    % UI to b/t FR  edge (for PB FR)
Dim5  = 0;                  % Separation between TX FRs
Dim6  = DFP_Frame2button;   % Separation between TX and ET
Dim7  = DFP_Frame2button;   % Separation between UIs within the FR
Dim8  = 0;                  % Separation between lower TX and PB FRs

TXx = 240 * DFP_ScaleX;     % TEXT object width
TXy =  24 * DFP_ScaleY;     % TEXT object height

ETx = TXx*(2/5);            % EDITABLE TEXT object width
ETy = TXy;                  % EDITABLE TEXT object height

PBx = DFP_UIcontrolBox_X;   % PUSHBUTTON object width
PBy = DFP_UIcontrolBox_Y;   % PUSHBUTTON object height


PUx = DFP_UIcontrolBox_X*2; % POP-UP MENU object width
PUy = DFP_UIcontrolBox_Y;   % POP-UP MENU object height

%
% FRAME objects
%==============
FRx   =   TXx + 2*Dim3 + Dim6 + ETx;
FRy1  =   TXy + 2*Dim4;
FRy2  = 2*TXy + 2*Dim4 +   Dim7;
FRy3  = 3*TXy + 2*Dim4 + 2*Dim7;
FRyp  =   PBy + 2*Dim41;
FRpos = [ 
         Dim1  Dim2+FRyp+Dim8+2*FRy2+3*Dim5+FRy3   FRx  FRy1;  % 1
         Dim1  Dim2+FRyp+Dim8+FRy2+2*Dim5+FRy3     FRx  FRy2;  % 2
         Dim1  Dim2+FRyp+Dim8+FRy2+Dim5+FRy3-FRy2  FRx  FRy2;  % 32 this
         Dim1  Dim2+FRyp+Dim8+FRy2+Dim5            FRx  FRy3;  % 33 or this
         Dim1  Dim2+FRyp+Dim8                      FRx  FRy2;  % 4
         Dim1  Dim2                                FRx  FRyp;  % 5
        ];

%
% TEXT objects
%=============
TXpos = [ 
         ...
         FRpos(1,1)+Dim3  FRpos(1,2)+Dim4               TXx  TXy;
         ...
         FRpos(2,1)+Dim3  FRpos(2,2)+Dim4+  TXy+  Dim7  TXx  TXy;
         FRpos(2,1)+Dim3  FRpos(2,2)+Dim4               TXx  TXy;
         ...
         FRpos(4,1)+Dim3  FRpos(4,2)+Dim4+2*TXy+2*Dim7  TXx  TXy;
         FRpos(4,1)+Dim3  FRpos(4,2)+Dim4+  TXy+  Dim7  TXx  TXy;
         FRpos(4,1)+Dim3  FRpos(4,2)+Dim4               TXx  TXy;
         ...
         FRpos(5,1)+Dim3  FRpos(5,2)+Dim4+  TXy+  Dim7  TXx  TXy;
         FRpos(5,1)+Dim3  FRpos(5,2)+Dim4               TXx  TXy;
        ];
TXstr = str2mat( 'Sampling Frequency',     ...
                 '' , '' , '' , '' , '' , '' , '' );

%
% POP-UP MENU  objects
%=====================
Dim11 = (FRx-PUx)/2;
PUpos = [ Dim11   FRpos(1,2)+FRpos(1,4)+3*Dim21  PUx  PUy ];
PUstr = [ 'Low Pass|High Pass|Band Pass|Band Stop|Differentiator|' ... 
          'Hilbert Transform' ];
          % |All Pass|Communication|Multi Band|Notch|Comb|User Defined' ];

%
% EDITABLE TEXT  objects
%=======================
ETpos = [TXpos(:,1)+TXx+Dim6  TXpos(:,2) ETx*ones(8,1) ETy*ones(8,1)];

%
% PUSHBUTTON  objects
%=======================
Dim9  = (FRx -2*PBx)/3;
Dim10 = (FRyp-  PBy)/2;
PBpos = [
         FRpos(6,1)+  Dim9      FRpos(6,2)+Dim10   PBx  PBy;
         FRpos(6,1)+2*Dim9+PBx  FRpos(6,2)+Dim10   PBx  PBy;
        ];
PBcb  = str2mat( 'd_tspcb' , 'd_navgcb(7,0)' );
PBstr = str2mat( 'Apply' ,     'Close' );

%==============
% Create FIGURE
%==============
REFpos = get(findobj(get(0,'children'),'flat','Tag','fig1'),'Position');
FIGx   = FRx  + 2*Dim1;
FIGy   = FRy3+2*FRy2+FRy1+FRyp + 6*Dim21 + 3*Dim5 + Dim8 + TXy + Dim1;
FIGpos = [ DFP_WinBorderOffset+REFpos(1) REFpos(2)-FIGy-DFP_Offset3 ];
FIGhan = figure(                                          ...
              'Position',      [FIGpos FIGx FIGy],        ...
              'Visible',       'off',                     ...
              'Color',          DFP_UIbgroundcolor,       ...
              'Name',           d_namesv(FigNo),          ...
              'MenuBar',       'none',                    ...
              'BackingStore',  'off',                     ...
              'NumberTitle',   'off',                     ...
              'Tag',           ['fig' num2str(FigNo)],    ...
              'Resize',         DFP_FigureResize,         ...
              'NextPlot',      'new',                     ...
              'UserData',       DFP_initial               ...
              );

%============================
% Create and place UI objects
%============================
%
% FRAME objects
%==============
for ii = 1:size(FRpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'Frame',               ...
              'Position',            FRpos(ii,:)           ...
              );
    end
%
% TEXT  objects
%==============
for ii = 1:size(TXpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'Text',                ...
              'HorizontalAlignment','left',                ...
              'Position',            TXpos(ii,:),          ...
              'String',              deblank(TXstr(ii,:))  ...
              );
    end
%
% EDITABLE TEXT objects
%======================
for ii = 1:size(ETpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'Edit',                ...
              'BackGroundColor',     DFP_ETbgroundcolor,   ...
              'HorizontalAlignment','left',                ...
              'String',              '',                   ...
              'Callback',            '',                   ...
              'Position',            ETpos(ii,:)           ...
              );
    end
%
% PUSHBUTTON objects
%===================
for ii = 1:size(PBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'pushbutton',          ...
              'HorizontalAlignment','center',              ...
              'Position',            PBpos(ii,:),          ...
              'Callback',            deblank( PBcb(ii,:)), ...
              'String',              deblank(PBstr(ii,:))  ...
              );

    end
%
% POP-UP MENU objects
%=====================
    uicontrol( FIGhan,                                     ...
              'Style',              'popupmenu',           ...
              'HorizontalAlignment','center',              ...
              'String',              PUstr,                ...
              'CallBack',           'd_tspsup',   ...
              'Position',            PUpos                 ...
              );
%
% FIG has been set-up
%====================
set( get(FIGhan,'Children'), 'Units', 'normalized' );
