function  d_tspcb( FILTtypeNumber )
%D_TSPCB is the callback function for the APPLY pushbutton in the
%        "TYPE and SPECIFICATIONS" window.
%
%        D_TSPCB( FILTtypeNumber ) initiates the callback corresponding to
%        filter type FILTtypeNumber, where FILTtypeNumber = 1 --> LPF and
%        so on.   This is the callback function where (possibly new) entries
%        from the editable text fields of the "TYPE and SPECIFICATIONS" window
%        are read, and call to target generation and drawing routines and
%        the "METHOD" window set-up functions are made.
%
%        D_TSPCB with no input arguments simply determines the selected
%        FILTtypeNumber form the pop-up-menu value of the same figure.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global  DFP_fir        DFP_fs                          ...
        DFP_aa         DFP_bb                          ...
        DFP_aaQ        DFP_bbQ                         ...
        DFP_bottom     DFP_bottomstr  DFP_bottomsymbol ...
        DFP_top        DFP_topstr     DFP_topsymbol    ...
        DFP_gain

%=====================================================================
%  0. First some basic house keeping
%     Get some handles to the objects with which we will be working 
%     Then reset labels on the DISPLAY window, as we assume that each 
%     time the APPLY PB on the TYPESPEC window is pressed we start
%     with a new design.
%=====================================================================
FIG1han = findobj(get(0,'children'),'flat','Tag','fig1');
FIG2han = findobj(get(0,'children'),'flat','Tag','fig2');
FIG3han = findobj(get(0,'children'),'flat','Tag','fig3');
FIG4han = findobj(get(0,'children'),'flat','Tag','fig4');

CHLDhan = get(FIG2han,'Children');
EThan   = sort(findobj(CHLDhan,'flat', 'Type','uicontrol','Style','edit'));

if ( nargin < 1 )
   FILTtypeNumber = get(findobj(CHLDhan,'flat','Style','popupmenu'),'Value');
end

ptr_index = [FILTtypeNumber 8 4 2];
for ii = 1:4
    d_setlbl( ii, ptr_index(ii) );
end

%=====================================================================
%  1. Read the EDITABLE TEXT fields from the "Filter Specifications"
%     figure window.  These fields contain the NEW filter spec's such 
%     as sampling rate, cut-off frequencies, attenuation etc.
%=====================================================================
SpecData = zeros(1,length(EThan));
for ii = 1:length(EThan)
    SpecData(ii) = str2num( get(EThan(ii),'String') );
end
if( ~d_tspchk( FILTtypeNumber, SpecData )); return; end

%=====================================================================
%  2. Read the USERDATA of the same figure.  This array contains all
%     earlier spec's for ALL filter types.  So we must update the
%     USERDATA based on the new entries into the EDITABLE TEXT fields.
%
%     FILTterms is an array that specifies how many filter
%     specifications are needed for each FILTtype. 
%     For example FILTterms(1) = 5, as FILTtypeNumber=1 indicates
%     a LPF for which we need [ fs fp Ap fc Ac ];
%=====================================================================
ETdata    = get( FIG2han, 'Userdata' );
FILTterms = [ 5 5 8 8 5 5 ];
NN        = FILTterms(  FILTtypeNumber );
ETdata(FILTtypeNumber,1:NN) = SpecData(1:NN);
set( FIG2han, 'Userdata' , ETdata );

%======================================================================
%  3. The following three parameters translate the peculiarities of the
%     various filter types to display configurations.  In particular,
%     SCALE = {1,0} default Magnitude scale mode: 1-->dB and 0-->Linear
%     FLAG  = {1,0} are there any non-rectangular regions in the TARGET
%             that DFP_TARGETDRAW should know? 1-->Yes and 0--> No.
%     ACTION = {'enable','disable'} is there a TARGET to be drawn, if
%             there is one the ACTION is 'enable' the Target-Uimenu,
%             else, 'disable' the Target-Uimenu. 
%======================================================================

SCALE  = 1;         if( sum(FILTtypeNumber == [5 6]) ); SCALE = 0; end
FLAG   = 0;         if( sum(FILTtypeNumber == [5  ]) );  FLAG = 1; end
ACTION = 'enable';

%======================================================================
%  4. If there are a previous Magnitude/Phase/Pole-Zero plots, delete.
%======================================================================

CHLDhan = get( FIG4han, 'Children' );
delete( [ findobj(CHLDhan,'Type','line'); ... 
findobj(findobj(CHLDhan,'flat','Type','axes','Tag','axes:poz'),'Type','text')])
set( [findobj(CHLDhan,'flat','Type','uicontrol','Style','edit'); findobj(   ...
      CHLDhan,'flat','Type','uicontrol','Style','text','Tag','fig4:value')],...
     'String', '' )

ET4han  = findobj(get(FIG4han,'children'),'flat','Style','edit');
SL4han  = findobj(get(FIG4han,'children'),'flat','Style','slider');
TX4han  = findobj(get(FIG4han,'children'),'flat','Style','text', ...
                                                 'Tag', 'fig4:value');
set( [ET4han; TX4han], 'String', '' );
set( SL4han, 'Visible', 'off' );
DFP_fs           =  1; 
DFP_aa           =  1; 
DFP_bb           =  1; 
DFP_aaQ          =  1; 
DFP_bbQ          =  1; 
DFP_bottom       =  1; 
DFP_top          =  1; 
DFP_gain         =  1;
DFP_bottomstr    = ''; 
DFP_bottomsymbol = 'a'; 
DFP_topstr       = ''; 
DFP_topsymbol    = 'b';
DFP_fir          =  1;

%======================================================================
%  5. Reset "checked" status of the RBs in the DFP Design Method window
%======================================================================

set( findobj(get(FIG3han,'Children'),'flat','Style','radiobutton'),'Value',0);

%=====================================================================
%  6. Call the target drawing routines 
%=====================================================================

[x,y,z] = d_tgtgen( FILTtypeNumber, SpecData(1:NN) );
d_tgdraw( x, y, z, FLAG );
d_tgmncb( ACTION );
d_scmncb( SCALE );               % switch to dB/Linear scale 

d_navgcb(  2    );           % Open the DISPLAY window
d_mtdsup( FILTtypeNumber );  % Set-up uicontrols in the METHOD window
d_navgcb(  7, 0 );           % Close the SPEC window
d_navgcb(  8, 1 );           % Open the METHOD window

set( findobj(FIG1han,'Type','uimenu', 'Tag','fig1:uimenu:save'),'Enable','off');
set( FIG4han,'Name', d_namesv(4) );
