function d_tgmncb( action )
%D_TGMNCB is the callback used by the TARGET-MENU in the "DISPLAY" window.
%       
%        D_TGMNCB toggles between the "on" and "off" states.
%        Reads the "checked" status of the TARGET menu, and switches
%        to the other state, and sets the "Visible" property of the
%        TARGET line object.
%
%        D_TGMNCB( ACTION ) where ACTION equals 'on' or 'off', 
%        functions as before except it explicitly set the TARGET to the 
%        ACTION state.
%
%        D_TGMNCB( ACTION ) where ACTION equals 'enable' or 'disable', 
%        is used to address the needs of the filter types with no TARGET.
%        ENABLE : [  enable TARGET menu ] + [ D_TGMNCB('on')  ]
%        DISABLE: [ disable TARGET menu ] + [ D_TGMNCB('off') ]

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

MNhan  = findobj( 'Type', 'uimenu', 'Tag', 'menu4:target'                );
HANDLE = findobj( 'Type', 'uimenu', 'Tag', 'menu4:db',    'Checked', 'on');
SCALE  = ~isempty(HANDLE);
NEWhan = findobj( 'Type', 'line',   'Tag', 'plot:target', 'Userdata', SCALE);

present_state = [];
if (  ~exist('action') )
     present_state = get( MNhan, 'checked' );
     action = [];
end
if ( strcmp(action,'on') | strcmp(present_state,'off') )
     new_state = 'on';
     enb_state = 'on';
elseif ( strcmp(action,'disable') )
     new_state = 'off';
     enb_state = 'off';
elseif ( strcmp(action,'enable') )
     new_state = 'on';
     enb_state = 'on';
else
     new_state = 'off';
     enb_state = 'on';
end

set(  MNhan, 'Checked', new_state, 'Enable', enb_state );
set( NEWhan, 'Visible', new_state);

