function d_tgdraw(x,yAug,z, FLAG)
%D_TGDRAW draws filter target into the Magnitude AXES of the "DISPLAY" window.
%
%         D_TGDRAW(X,Y,Z) draws the filter target as specified by the
%         input arrays X,Y,Z.   These three arrays are generated by a call
%         to the function D_TGTGEN with the appropriate filter number.
%         For those filter types where target is not applicable, let the
%         X = [] and Y = [].   However, the Z array must be of the form:
%         Z = [ fs 0 YmaxLIN; fs YminLOG YmaxLOG ].
%
%         D_TGDRAW(X,Y,Z, FLAG ) where FLAG = 0/1 is useful where the target
%         regions indicated by X and Y contains irregular polygonal regions.
%         If FLAG input is omitted, FLAG = 0, i.e. all target regions are
%         assumed to be rectangular.  

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global DFP_TARGETcolor 

DFP_TargetDotDelta = 0.02;

if ( nargin == 3 )
   FLAG = 0;
end

MAGAXhan = findobj(findobj(get(0,'Children'),'flat','Tag','fig4'), ...
                   'Type', 'axes', 'Tag', 'axes:mag' );
axes(MAGAXhan);

%========================================================================
% if there is a previous target of the specific type (lin/log) delete it
%========================================================================

delete( findobj( MAGAXhan,'type','line','Tag','plot:target') );

Nrow = size(yAug,1)/2;

%========================================
% Loop for LINEAR and LOG target drawing
%========================================

for ii = 1:2

    y = yAug( 1+(ii-1)*Nrow : Nrow+(ii-1)*Nrow, : );
    fs = z(ii,1); 
    Ymin = z(ii,2);
    Ymax = z(ii,3);

    x_delta = DFP_TargetDotDelta * fs;
    y_delta = x_delta * 2 * (Ymax-Ymin)/fs;
    Xmatrix = [min(x); max(x)]; Ymatrix = [min(y); max(y)];
    %========================================================================
    %  Can the above info be extracted from the axes ASPECTratio property?
    %========================================================================

    %========================================================================
    %  Each column of Xmatrix represents one target region.  As many times
    %  through the loop as the number of regions.
    %========================================================================

    for nn = 1:size(Xmatrix,2)

        xm = Xmatrix(:,nn);                 ym = Ymatrix(:,nn);
        xstart = min(xm); xstop = max(xm);  ystart = min(ym); ystop = max(ym);
        xx = [ xstart : x_delta : xstop ];  yy = [ ystart : y_delta : ystop ]; 
        %====================================================================
        % The next IF statement is an ad-hoc fix for a MATLAB inconsistency.
        % On UNIX systems yy = [ NaN:2:NaN ] = NaN, whereas on PCWIN
        % yy = [ NaN:2:NaN ] = [].  This creates errors if not accounted for.
        % YSTART and YSTOP are NaN for the DIFFERENTIATOR case where we do
        % not know how to draw the DB scale TARGET.  Is this a bug? Verify
        % with MATHWORKS ........ MZ. 1996.10.12.
        %====================================================================
        if ( isempty(yy) ); yy = NaN; end
        nx = length(xx);                    ny = length(yy);
        xa = xx(ones(1,ny),:);              ya = yy(ones(1,nx),:); ya = ya';

        %==================================================
        % Offset the even indexed rows for esthetic reasons
        %==================================================

        xa(2:2:size(xa,1),:) = xa(2:2:size(xa,1),:) + (x_delta/2);
   
        %===================================================================
        % (FLAG == 1) implies that the region to be filled with "dots" is a
        % non-rectangular polygon.  The above procedure computes the "dot"
        % locations in the minimum  _rectangular_ region which can inscribe
        % the polygon.  Hence, we need to eliminate the the "dots" that are
        % outside of the polygon.   In the D_TSPCB function we know
        % which Filter Types have targets with irregular polygonal regions.
        %
        % (FLAG == 0) on the other hands means that all what we need is to 
        % trim off the "dots" that protrude beyond the limits as a
        % result of right-shifting the alternate rows of "dots" by x_delta/2.
        % This is the case for the four basic filter types: LPF/HPF/BPF/BSF.
        %
        % Remark: I believe the information about the rectangular vs.
        % non-rectangular target regions can be extracted at this point.
        % I will come back to this point later.
        %===================================================================

        if ( FLAG )
           M = length(y(:,nn));
           if ( y(1,nn) == y(M,nn) )
              px = [ x(:,nn); x(1,nn) ];
              py = [ y(:,nn); y(1,nn) ];
           else
              px = [ x(:,nn); x(1,nn); x(1,nn) ];
              py = [ y(:,nn); y(M,nn); y(1,nn) ];
           end
           idx = inpolygon( xa, ya, px, py );
           xa  = xa(idx);
           ya  = ya(idx);
        else
           xa = limiter(xa,xstart,xstop);
           ya = limiter(ya,ystart,ystop);
        end

        %===============================
        % draw the dots first
        %===============================

        line(  xa, ya,                         ...
              'Color',        DFP_TARGETcolor, ...
              'LineStyle',   '.',              ...
              'Visible',     'off',            ...
              'Tag',         'plot:target',    ...
              'Userdata',    (ii-1)              );

    end

    line( x, y,                                ...
              'Color',        DFP_TARGETcolor, ...
              'Visible',     'off',            ...
              'LineStyle',   '-',              ...
              'Tag',         'plot:target',    ...
              'Userdata',     (ii-1)             );  % Linear -> Userdata = 0 
                                                     % dB -> Userdata = 1

    axis([0 fs/2 Ymin Ymax]);

    %=======================================================================
    % The MATLAB provided zoom function manipulates with USERDATA of the
    % ZLABEL object of the AXES object into which we want to zoom in and out.
    % Due to the existence of both the LINEAR and the dB data on the same 
    % AXES, the zoom function was behaving very erratically (especially when 
    % we zoom out by double clicking). It was zooming out to the limits of 
    % the other plot, i.e., set AXES to LINEAR, zoom in, then zoom out by 
    % double clicking, and you  get the AXES limits set to the values of the 
    % dB plot!!
    %
    % So here I save the correct AXES limits in the 2x4 USERDATA array such
    % that USERDATA = [ linear limits; log limits ].  The DFP_SCALECB
    % functions which implements the switching between the Linear and dB
    % modes reads this data, and  _explicitly_ sets the 
    % MAGAXhan->ZLABEL->USERDATA = (row 1) or (row 2), depending on the
    % selected mode.   It seemed to cure the problem.  Still, there is
    % something not 100% kosher about the zoom function.
    %=======================================================================

    USERdata(ii,:) = [0 fs/2 Ymin Ymax];

end

set(MAGAXhan,'Userdata',USERdata);

