function d_spmncb( Action )
%D_SPMNCB is the callback for the SNAPSHOT-MENU in the "DISPLAY" window.
%
%         D_SPMNCB( AXES ) creates a new figure and uimenu objects and a
%         new axes object in this new figure window, and copies (takes a
%         snapshot) of the AXES into the new axes.
%         AXES = 1 : copy the Magnitude AXES,
%                2 : copy the Phase/Group Delay/Impulse Response AXES
%                3 : copy the Pole-Zero AXES.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

global   DFP_ScaleX   DFP_ScaleY

OldAxes = sort(findobj( get(findobj(get(0,'Children'),'flat','Tag','fig4'),...
                       'Children'),'Type','axes'));
OldAxes = OldAxes( Action );

FIGpos = get(0,'DefaultFigurePosition');
FIGpos = [ FIGpos(1)*DFP_ScaleX  FIGpos(2)*DFP_ScaleY ...
           FIGpos(3)*DFP_ScaleX  FIGpos(4)*DFP_ScaleY    ];
FIGhan = figure( 'Position', FIGpos, ...
                 'Visible', 'off',   ...
                 'Color',    get(get(OldAxes,'Parent'),'Color'));

MNhan = uimenu( FIGhan, ...
                                 'Label',         'File',       ...
                                 'Accelerator',   'F'              );
                uimenu( MNhan,   'Label',         'Print ...',  ...
                                 'CallBack',      'uiprint;'       );
                uimenu( MNhan,   'Label',         'Close ',     ...
                                 'Separator',     'on',         ...
                                 'CallBack',      'delete(gcf)'    );
MNhan = uimenu( FIGhan, ...
                                 'Label',         'Time Stamp', ...
                                 'Accelerator',   'T'              );
                uimenu( MNhan,   'Label',         'On  ',       ...
                                 'Userdata',      'timestamp',  ...
                                 'Checked',       'off',        ...
                                 'Tag',           'time:on',    ...
                                 'Callback',      'd_datest on;'   );
                uimenu( MNhan,   'Label',         'Off ',       ...
                                 'Userdata',      'timestamp',  ...
                                 'Checked',       'on',         ...
                                 'Tag',           'time:off',   ...
                                 'Callback',      'd_datest off;'  );

drawnow

NewAxes   = axes( 'Color',   get(OldAxes,'Color') );

hN(1) = get(NewAxes,'xlabel'); hO(1) = get(OldAxes,'xlabel');
hN(2) = get(NewAxes,'ylabel'); hO(2) = get(OldAxes,'ylabel');
hN(3) = get(NewAxes,'title');  hO(3) = get(OldAxes,'title');

for ii = 1:3
    set(hN(ii), 'FontAngle',  get(hO(ii), 'FontAngle'),  ...
                'FontName',   get(hO(ii), 'FontName'),   ...
                'FontSize',   get(hO(ii), 'FontSize'),   ...
                'FontWeight', get(hO(ii), 'FontWeight'), ...
                'String',     get(hO(ii), 'String')          );
end

set( NewAxes, 'Box',          get(OldAxes,'Box'), ...
              'Color',        get(OldAxes,'Color'), ...
              'Aspect',       get(OldAxes,'Aspect'), ...
              ...
              'Xlim',         get(OldAxes,'Xlim'), ...
              'Xlimmode',     get(OldAxes,'Xlimmode'), ...
              'Xgrid',        get(OldAxes,'Xgrid'), ...
              'Xscale',       get(OldAxes,'Xscale'), ...
              ...
              'Ylim',         get(OldAxes,'Ylim'), ...
              'Ylimmode',     get(OldAxes,'Ylimmode'), ...
              'Ygrid',        get(OldAxes,'Ygrid'), ...
              'Yscale',       get(OldAxes,'Yscale')  ...
              );

makecopy( findobj(get(OldAxes,'Children'),'Visible','on'), NewAxes );
set( [get(FIGhan,'Children'); FIGhan], 'Visible', 'on');
