function  d_setlbl(arg1,arg2)
%D_SETLBL changes the status labels in the "DISPLAY" window.
%
%         D_SETLBL( INDEXx, INDEXy ) modifies the status label INDEXx by 
%         setting its label to the string INDEXy in the string array
%         "arrINDEXx".   
%         INDEXx = 1  : Low Pass     - High Pass   -  ...  -  ______
%                  2  : FIR/Remez    - FIR/Window  -  ...  -  ______
%                  3  : Polynomial   - Lattice     -  SOS  -  ______
%                  4  : Coeff: float - (see below)         -  Coeff: _____
%         INDEXy = [1--7] for INDEXx = 1
%         INDEXy = [1--8] for INDEXx = 2
%         INDEXy = [1--4] for INDEXx = 3
%         INDEXy = [1--2] or a string array of the form:
%                  [Total # of bits, Integer Bits, t/u] (t=2sComp;u=unsigned) 
%                  if INDEXx = 4
%

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

arr1 = [ 'Low Pass      ';
         'High Pass     ';
         'Band Pass     ';
         'Band Stop     ';
         'Differentiator';
         'Hilbert       ';
         '______        ' ];
arr2 = [ 'FIR/Remez      ';
         'FIR/Window     ';
         'FIR/LstSq      ';
         'IIR/Butterworth';
         'IIR/ChebyI     ';
         'IIR/ChebyII    ';
         'IIR/Elliptic   ';
         '______         ' ];
arr3 = [ 'Polynomial' ;
         'Lattice   ' ;
         'SOS       ' ;
         '______    ' ];
arr4 = [ 'Coeff: float   ';
         'Coeff: _____   '];

arrW = [ 'Kaiser  ' ;
         'Bartlett' ;
         'Blackman' ;
         'Hamming ' ;
         'Hanning ' ;
         'Boxcar  ' ];

tag   = sprintf('fig4:sta%i',arg1);
if ( isstr(arg2) )
   array = arg2;
else
   array = sprintf('arr%i(%i,:)',arg1,arg2); 
   array = deblank(eval(array));
   if ( (arg1==2) & (arg2==2) )
      FIG3han = findobj(get(0,'Children'),'flat','Tag','fig3');
      PUhan   = findobj(get(FIG3han,'Children'),'flat','Style','popupmenu');
      WinType = get(PUhan,'Value');
      array   = strrep( array, 'Window', deblank(arrW(WinType,:)) );
   end
end

set( findobj(get(findobj(get(0,'Children'),'flat','Tag','fig4'),'Children'),...
     'flat','Tag', tag  ), 'String', array );
