function d_scmncb( SCALE )
%D_SCMNCB is the callback function for the SCALE-MENU in the "DISPLAY" window.
%
%        D_SCMNCB function manages switching between dB/linear scales in the
%        magnitude plot axes.  
%        D_SCMNCB( SCALE ) where the input argument SCALE = 1-->dB, 0-->Linear
%        If no input argument is given, we checked whether dB or LINEAR
%        has been checked, and uses the SCALE accordingly. 

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

FIG4han  = findobj( get(0,'children'),'flat', 'Tag',  'fig4');
DBhan    = findobj( FIG4han, 'Type','uimenu', 'Tag',  'menu4:db');
LINhan   = findobj( FIG4han, 'Type','uimenu', 'Tag',  'menu4:lin');
TARhan   = findobj( FIG4han, 'Type','uimenu', 'Tag',  'menu4:target');
MAGAXhan = findobj( get(FIG4han,'children'),  'flat', 'Type', 'axes', ...
                                              'Tag',  'axes:mag'        );
LINElog  = findobj( get(MAGAXhan,'children'),'flat', ...
                    'Type','line','Tag','plot:mag', 'Userdata', 1);
LINElin  = findobj( get(MAGAXhan,'children'),'flat', ...
                    'Type','line','Tag','plot:mag', 'Userdata', 0);
USERdata = get(     MAGAXhan, 'Userdata' );

axes( MAGAXhan );

if ( nargin == 0 )

   if ( ~isempty(findobj(DBhan,'Checked','on')) ) 
      SCALE = 1;
   elseif( ~isempty(findobj(LINhan,'Checked','on')) )
      SCALE = 0;
   end

end

if ( SCALE ) % ========= dB Scale ================

   set( DBhan,'Checked','on' );
   set(LINhan,'Checked','off');
   if ( get(TARhan,'Checked') )
      LINElin = [ LINElin; ...
                  findobj(MAGAXhan,'Tag','plot:target','Userdata',~SCALE)];
      LINElog = [ LINElog; ...
                  findobj(MAGAXhan,'Tag','plot:target','Userdata', SCALE)];
   end
   axis( USERdata(2,:) );
   ylabel('Magnitude [dB]');
   set( LINElog,  'Visible', 'on');     
   set( LINElin,  'Visible', 'off');     
   set( get(MAGAXhan,'Zlabel'),'Userdata', USERdata(2,:) );

else       % ========== LINEAR scale ==============

   set(LINhan,'Checked','on'  );
   set( DBhan,'Checked','off' );
   if ( get(TARhan,'Checked') )
      LINElin = [ LINElin; ...
                  findobj(MAGAXhan,'Tag','plot:target','Userdata', SCALE)];
      LINElog = [ LINElog; ...
                  findobj(MAGAXhan,'Tag','plot:target','Userdata',~SCALE)];
   end
   axis( USERdata(1,:) ); 
   ylabel('Magnitude');
   set( LINElog, 'Visible', 'off');
   set( LINElin, 'Visible', 'on');
   set( get(MAGAXhan,'Zlabel'),'Userdata', USERdata(1,:) );

end
