function d_rstdef( Action )
%D_RSTDEF restores the user modifiable DFP parameters and
%        properties to their default values relative to the start of
%        the "PROPERTIES" dialog box.
%
%        D_RSTDEF( 0 ) restores all the user modifiable
%        DFP parameters and properties to their global default values
%        as specified in the DFPRCDEF script file.
%
%        D_RSTDEF( 1 ) restores all the user modifiable
%        DFP parameters and properties to their user specific default
%        values as specified in the DFPRC script file.
%        
%        If no input argument is given in calling D_RSTDEF
%        its action is equivalent to D_RSTDEF( 0 ).

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global   DFP_AXbgroundcolor  DFP_TARGETcolor     DFP_MAGcolor     ...
         DFP_PHASEcolor      DFP_POLEcolor       DFP_ZEROcolor    ...  
         DFP_Directory       DFP_SourceCodeDir   DFP_TemplatesDir ...
         DFP_FREQZpoints     DFP_FigureResize    DFP_POLEZEROaxis ...
         DFP_UIbgroundcolor  DFP_ColorMonitor

if ( nargin < 1 ); Action = 0; end

if ( Action == 1 )

   if ( exist('dfprc') )
      dfprc;
   else
      d_error( 'WP-01' );
      Action = 0;
   end

end

if ( Action == 0 )

   if ( exist('dfprcdef') )
      dfprcdef;
   else
      d_error( 'EP-01' );
      return
   end

end

FIG4han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig4' );

%
%  DISPLAY AXES backgroundcolor
%==============================
set( findobj(get(FIG4han,'Children'),'flat','Type','axes'), ...
                                            'Color', DFP_AXbgroundcolor );
set( FIG4han, 'DefaultAxesColor', DFP_AXbgroundcolor );

%
%  DISPLAY TARGET backgroundcolor
%================================
set( findobj(get(FIG4han,'Children'),'Type','line', 'Tag','plot:target'), ...
                                            'Color', DFP_TARGETcolor );

%
%  DISPLAY MAGNITUDE backgroundcolor
%===================================
set( findobj(get(FIG4han,'Children'),'Type','line', 'Tag','plot:mag'), ...
                                            'Color', DFP_MAGcolor );

%
%  DISPLAY PHASE/GD/IMP backgroundcolor
%======================================
set( findobj(get(FIG4han,'Children'),'Type','line','Tag','plot:pha'), ...
                                            'Color', DFP_PHASEcolor );
%
%  DISPLAY POLE color
%====================
set( findobj(get(FIG4han,'Children'),'Type','line','LineStyle','x', ...
                        'Tag','plot:poz') , 'Color', DFP_POLEcolor );

%
%  DISPLAY ZERO color
%====================
set( findobj(get(FIG4han,'Children'),'Type','line','LineStyle','o', ...
                        'Tag','plot:poz') , 'Color', DFP_ZEROcolor );

%
%  DISPLAY POLE/ZERO axis color
%==============================
set( findobj(get(FIG4han,'Children'),'Type','line','LineStyle',':', ...
                        'Tag','plot:poz'), 'Color', DFP_POLEZEROaxis );
      
%
%  RESIZE figures?
%====================
set( get(0,'Children'), 'Resize', DFP_FigureResize );

%
%  If the PROPERTIES figure has been created modify its elements too
%===================================================================
[ Flag, Fig ] = figflag( d_namesv(8), 1 );

if ( Flag )

   PBhan = sort(findobj(get(findobj(get(0,'Children'),'flat','Tag','fig8'),...
                'Children'),'flat','Style','pushbutton'));
   EThan = sort(findobj(get(findobj(get(0,'Children'),'flat','Tag','fig8'),...
                'Children'),'flat','Style','edit'));
   PUhan = sort(findobj(get(findobj(get(0,'Children'),'flat','Tag','fig8'),...
                'Children'),'flat','Style','popupmenu'));
   RBfgc = [
             DFP_AXbgroundcolor;
             DFP_TARGETcolor;
             DFP_MAGcolor;
             DFP_PHASEcolor;
             DFP_POLEcolor;
             DFP_ZEROcolor;
             DFP_POLEZEROaxis;
           ];
   if ( DFP_ColorMonitor )
      RBbgc = DFP_UIbgroundcolor(ones(7,1),:);
   else
      RBbgc = ~RBfgc;
   end
   for ii = 1:7
    set(PBhan(ii),'ForegroundColor',RBfgc(ii,:),'BackgroundColor',RBbgc(ii,:)); 
   end
   set( EThan(3), 'String', DFP_Directory     );
   set( EThan(4), 'String', DFP_SourceCodeDir );
   set( EThan(5), 'String', DFP_TemplatesDir  );
   set( EThan(6), 'String', num2str(DFP_FREQZpoints) );
   value = 1;
   if ( strcmp(DFP_FigureResize,'on') ); value = 2; end
   set( PUhan(3), 'Value', value ); 

end
