function d_resize(alpha)
%D_RESIZE is the callback function for the "PoZe/Coff" checkbox in the
%         "NAVIGATOR" window.
%
%         D_RESIZE( DFP_alpha ) changes the DISPLAY window into the "smaller"
%         form such that only the Magnitude and the Phase/Gdelay/Impulse plots 
%         are visible.
%
%         D_RESIZE( 1/DFP_alpha ) changes the DISPLAY window into the "bigger"
%         form such that in addition to the Magnitude and the Phase/...
%         plots the Pole-Zero plot and the Coefficient windows are also
%         visible.
%
%         DFP_alpha is a global variable first determined in D_DISPLY.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

FIG4han = findobj(get(0,'Children'),'flat','Tag','fig4');
CHLDhan = get(FIG4han,'Children');
set(FIG4han,'units','pixels')

Mpos = get(findobj(CHLDhan,'flat','Type', 'axes', 'Tag','axes:mag'),   'Pos');
Ppos = get(findobj(CHLDhan,'flat','Type', 'axes', 'Tag','axes:pha'),   'Pos');
Fpos = get(findobj(CHLDhan,'flat','Style','frame','Tag','frame4:stat'),'Pos');

OldRect = [ 0 Ppos(2) 1 1-Ppos(2) ];
NewRect = [ OldRect(1) 1+(1/alpha)*(OldRect(2)-1) ...
            OldRect(3)   (1/alpha)*OldRect(4) ];

OldFigPos = get(FIG4han,'Position');
NewFigPos = [ OldFigPos(1) OldFigPos(2)-(alpha-1)*OldFigPos(4) ...
              OldFigPos(3)     alpha*OldFigPos(4)                 ];

remapfig(OldRect,NewRect,FIG4han);
set(FIG4han,'Position',NewFigPos);
