function FIGhan = d_recoef()
%D_RECOEF creates and initializes the "IMPLEMENTATION" window and its children.
%
%         FIG = D_RECOEF returns the handle to the figure object which has 
%         been created by calling the function D_RECOEF.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

%=================
% GLOBAL variables
%=================
global DFP_ETbgroundcolor   DFP_FigureResize     DFP_Frame2button    ...
       DFP_WinBorderOffset  DFP_UIcontrolBox_Y   DFP_UIcontrolBox_X  ...
       DFP_Offset3          DFP_SlateBluecolor   DFP_UIbgroundcolor  ...
       DFP_ScaleX           DFP_ScaleY


%==============
% FIGURE NUMBER
%==============
FigNo = 5;


%==============================
% Dimension definitions (local)
%==============================
Dim11 = 1;                  % FR to l/r FIG edge
Dim12 = 1;                  % FR to b FIG edge
Dim13 = 1;                  % FR to t FIG edge
Dim21 = 0;                  % Separation between upper two FRs
Dim22 = 0;                  % Separation between the lower FR and PB FR
Dim3  = 2*DFP_Frame2button; % From top of Label FR to the top of Big FR
Dim31 = 4*DFP_Frame2button;
Dim4  = 4*DFP_Frame2button;
Dim5  = 20 * DFP_ScaleY;
Dim6  = 4*DFP_Frame2button; % Hor Separation CB --> short ETs
Dim7  = 2 * DFP_ScaleY;     % Separation between lower TX and PB FRs

UIx   = (60*DFP_ScaleX) + DFP_UIcontrolBox_X;      % expanded UI width

ETx = 40 * DFP_ScaleX;
ETy = DFP_UIcontrolBox_Y-(2*DFP_ScaleY); % EDITABLE TEXT object height

PBx = DFP_UIcontrolBox_X;   % PUSHBUTTON object width
PBy = DFP_UIcontrolBox_Y;   % PUSHBUTTON object height

RBx = UIx;                  % RADIOBUTTON object width
RBy = DFP_UIcontrolBox_Y;   % RADIOBUTTON object height

TXx = DFP_UIcontrolBox_X;   % TEXT object width
TXy = DFP_UIcontrolBox_Y;   % TEXT object height

PUx = DFP_UIcontrolBox_X*2.5;     % POP-UP MENU object width
PUy = DFP_UIcontrolBox_Y*1.2;     % POP-UP MENU object height

%
% FRAME objects
%==============
FRTXy = TXy  + 2*Dim7;
FRTXx = Dim6 + 2*RBx;

FRxs  = RBx; 
FRys  = (6*DFP_ScaleY) + 3*RBy; 

FRx   = 3*Dim6 + 2*RBx;
FRy1  =   FRys + 2*Dim31 + Dim3 + FRTXy;
FRy2  = 2*TXy  +   Dim31 + Dim3 + FRTXy + PUy + 2*Dim4;
FRy3  =   PBy  + 2*Dim5;

FRpos = [ 
         Dim11  Dim12+FRy3+Dim22+FRy2+Dim21   FRx  FRy1;
         Dim11  Dim12+FRy3+Dim22              FRx  FRy2;
         Dim11  Dim12                         FRx  FRy3;
        ];
FRpos = [
         FRpos;
         ...
         Dim11+Dim6        FRpos(1,2)+2*Dim31+FRys            FRTXx  FRTXy;
         Dim11+Dim6        FRpos(2,2)+Dim31+2*TXy+2*Dim4+PUy  FRTXx  FRTXy;
         Dim11+2*Dim6+RBx  FRpos(1,2)+Dim31                   FRxs   FRys;
        ];

%
% RADIOBUTTON  objects
%=====================
aa    = 3*DFP_ScaleY;
RBx1  = RBx-(6*DFP_ScaleX);
RBx2  = (FRxs-(8*DFP_ScaleX))/2.5;
DimD  = FRpos(6,1)+(2*DFP_ScaleX)+(FRxs-(2*DFP_ScaleX)-2*RBx2)/2;
RBval = [  1 0 0   1 0  1 0 ];
RBpos = [
         FRpos(1,1)+Dim6   FRpos(1,2)+FRys/2+Dim31       RBx   RBy;
         FRpos(1,1)+Dim6   FRpos(1,2)+FRys/2+Dim31-RBy   RBx   RBy;
         FRpos(6,1)+3      FRpos(6,2)+aa+2*RBy           RBx1  RBy;
         DimD              FRpos(6,2)+aa                 RBx2  RBy;
         DimD+RBx2         FRpos(6,2)+aa                 RBx2  RBy;
         ...
         FRpos(2,1)+2*Dim6+RBx   FRpos(2,2)+Dim31+RBy    RBx   RBy;
         FRpos(2,1)+2*Dim6+RBx   FRpos(2,2)+Dim31        RBx   RBy;
        ];
RBstr = str2mat( ' Polynomial' ,         ...
                 ' Lattice' ,            ...
                 '2nd Order Sections',   ...
                 ' Yes',                 ...
                 ' No',                  ...
                 ' Two''s Complement',   ...
                 ' Unsigned'                );
RBtag = str2mat( 'format',               ...
                 'format',               ...
                 'format',               ...
                 'gain',                 ...
                 'gain',                 ...
                 'fixed',                ...
                 'fixed'                    );
RBusr = str2mat( '',                     ...
                 '',                     ...
                 'sos',                  ...
                 'sos',                  ...
                 'sos',                  ...
                 '',                     ...
                 ''                         );

%
% TEXT objects
%==============
TXalg = str2mat( 'center', 'left', 'left', 'center', 'center' );
TXpos = [ 
         DimD             FRpos(6,2)+(3*DFP_ScaleY)+RBy RBx2*2  TXy;
         FRpos(2,1)+Dim6  FRpos(2,2)+Dim31+TXy          TXx     TXy;
         FRpos(2,1)+Dim6  FRpos(2,2)+Dim31              TXx     TXy;
         FRpos(4,:)+[2 0 -5 0]*DFP_ScaleX+[0 3 0 -5]*DFP_ScaleY; 
         FRpos(5,:)+[2 0 -5 0]*DFP_ScaleX+[0 3 0 -5]*DFP_ScaleY; 
        ];
TXstr = str2mat( 'Distribute Gain?',   'Number of Bits' , 'Integer Bits', ...
                 'Filter Realization', 'Filter Coefficients' );
TXtag = str2mat( 'gain', 'fixed', 'fixed' ,'', '');
TXusr = str2mat( 'sos',  'fixed', 'fixed' ,'', '');

TXbgc = [
          DFP_UIbgroundcolor;
          DFP_UIbgroundcolor;
          DFP_UIbgroundcolor;
          DFP_SlateBluecolor;
          DFP_SlateBluecolor;
        ];
TXfgc = [
          0 0 0;
          0 0 0;
          0 0 0;
          1 1 1;
          1 1 1;
        ];
TXenb = str2mat( 'off', 'off', 'off', 'on', 'on' );

%
% EDITABLE TEXT  objects
%=======================
ETpos = [
         FRpos(2,1)+Dim6+RBx-ETx  TXpos(2,2)  ETx  ETy;
         FRpos(2,1)+Dim6+RBx-ETx  TXpos(3,2)  ETx  ETy;
        ];
ETstr = str2mat( ' 24', ' 0' );
ETtag = str2mat( 'fixed', 'fixed' );

%
%  POP-UP MENU objects
%=======================
PUpos = [ FRpos(2,1)+FRx/2-PUx/2  TXpos(2,2)+TXy+Dim6   PUx  PUy ];
PUstr = 'Floating Point|Fixed Point';

%
% PUSHBUTTON  objects
%=======================
Dim   = (FRx -2*PBx)/3;
PBpos = [
         FRpos(3,1)+  Dim      FRpos(3,2)+Dim5   PBx  PBy;
         FRpos(3,1)+2*Dim+PBx  FRpos(3,2)+Dim5   PBx  PBy;
        ];
PBcb  = str2mat( 'd_implmt; d_dplydr([1 NaN 1]); d_scmncb', 'd_navgcb(10,0)');
PBstr = str2mat( 'Apply' , 'Close' );

%==============
% Create FIGURE
%==============
REFpos = get(findobj(get(0,'Children'),'flat','Tag','fig1'),'Position');
FIGx   = FRx + 2*Dim11;
FIGy   = FRy1 + FRy2 + FRy3 + Dim12 + Dim13 + Dim21 + Dim22;
FIGpos = [ DFP_WinBorderOffset+REFpos(1) REFpos(2)-FIGy-DFP_Offset3 ];
FIGhan = figure( ...
              'Position',     [FIGpos FIGx FIGy],         ...
              'Visible',      'off',                      ...
              'Color',         DFP_UIbgroundcolor,        ...
              'MenuBar',      'none',                     ...
              'Resize',        DFP_FigureResize,          ...
              'Name',          d_namesv(FigNo),           ...
              'BackingStore', 'off',                      ...
              'NumberTitle',  'off',                      ...
              'Tag',          ['fig' num2str(FigNo)],     ...
              'NextPlot',      'new'                      ...
              );

%============================
% Create and place UI objects
%============================
%
% FRAME objects
%==============
for ii = 1:size(FRpos,1)
    uicontrol( FIGhan,                                     ...
               'Style',              'Frame',              ...
               'Position',            FRpos(ii,:)          ...
             );
end
%
% TEXT  objects
%==============
for ii = 1:size(TXpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'Text',                ...
              'BackGroundColor',     TXbgc(ii,:),          ...
              'ForegroundColor',     TXfgc(ii,:),          ...
              'HorizontalAlignment', TXalg(ii,:),          ...
              'Position',            TXpos(ii,:),          ...
              'Enable',              deblank(TXenb(ii,:)), ...
              'Tag',                 deblank(TXtag(ii,:)), ...
              'UserData',            deblank(TXusr(ii,:)), ...
              'String',              deblank(TXstr(ii,:))  ...
              );
end
%
% EDITABLE TEXT objects
%======================
for ii = 1:size(ETpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'Edit',                ...
              'BackGroundColor',     DFP_ETbgroundcolor,   ...
              'HorizontalAlignment','left',                ...
              'String',              deblank(ETstr(ii,:)), ...
              'Callback',            '',                   ...
              'Min',                 0,                    ...
              'Max',                 0,                    ...
              'Enable',             'off',                 ...
              'Tag',                 deblank(ETtag(ii,:)), ...
              'Position',            ETpos(ii,:)           ...
              );
end
%
% RADIOBUTTON objects
%====================
for ii = 1:size(RBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'radiobutton',         ...
              'HorizontalAlignment','left',                ...
              'Position',            RBpos(ii,:),          ...
              'Callback',            sprintf('d_recocb(%i)',ii), ...
              'Value',               RBval(ii),            ...
              'Enable',             'off',                 ...
              'Tag',                 deblank(RBtag(ii,:)), ...
              'UserData',            deblank(RBusr(ii,:)), ...
              'String',              deblank(RBstr(ii,:))  ...
              );
end
%
% PUSHBUTTON objects
%===================
for ii = 1:size(PBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',              'pushbutton',          ...
              'HorizontalAlignment','center',              ...
              'Position',            PBpos(ii,:),          ...
              'Callback',            deblank( PBcb(ii,:)), ...
              'String',              deblank(PBstr(ii,:))  ...
              );
end
%
%  POP-UP MENU objects
%=======================
    uicontrol( FIGhan,                                     ...
              'Style',               'popupmenu',          ...
              'HorizontalAlignment', 'center',             ...
              'Position',             PUpos,               ...
              'Callback',            'd_recocb(8)',        ...
              'Enable',              'off',                ...
              'String',               PUstr                ...
             );

%
% FIG has been set-up, now return back to main program
%=====================================================
set( get(FIGhan,'Children'), 'Units', 'normalized' );
