function d_recocb( Action, arg2 )
%D_RECOCB is the callback function for the UICONTROL objects in the 
%         "IMPLEMENTATION" window.
%
%         D_RECOCB( ACTION, VALUE ) is the callback for the ACTION, where
%         ACTION = 1  : callback for the POLYNOMIAL radiobutton
%                  2  : callback for the LATTICE    radiobutton
%                  3  : callback for the SOS        radiobutton
%                  4  : callback for the DIST-GAIN:YES radiobutton
%                  5  : callback for the DIST-GAIN:NO  radiobutton
%                  6  : callback for the 2s-COMPLEMENT radiobutton
%                  7  : callback for the UNSIGNED      radiobutton
%                  8  : callback for the FLOAT/FIXED pop-up-menu. If only 1
%                       input argument is given then D_RECOCB checks the value
%                       of the pop-up and proceeds.  Otherwise if VALUE (1/2)
%                       is given it sets the pop-up to that value 1->FLOAT
%                       and 2->FIXED and then proceeds.
%                 10  : enables/disables SOS and others depending on DFP_fir
%
%         NOTE: What D_RECOCB does is to address the dependencies that exists
%         between the UICONTROLS of the "IMPLEMENTATION" and "OUTPUT" windows.
%         For example, if SOS in the "IMPLEMENTATION" window is not selected 
%         then the SOS checkbox in the "OUTPUT" window should be disabled.
%         The radiobuttons' mutually exclusive property is also done here.
%         Enabling/Disabling of certain elements such as the "Number of Bits/
%         Integer Bits" as a function of FLOAT/FIXED pop-up-menu is also
%         implemented here.
%         The actual changes on the filter coefficients as a result of the
%         selections made here is done in the function D_IMPLMT.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global DFP_fir

CHLDhan = get( findobj(get(0,'Children'),'flat','Tag','fig5'), 'children' );
RBhan   = sort(findobj(CHLDhan,'flat','Style','radiobutton'));
LBhan   =      findobj(CHLDhan,'flat','Style','text','Userdata','sos');
CHD6han = get( findobj(get(0,'Children'),'flat','Tag','fig6'), 'children' );
CB6han  = sort(findobj(CHD6han, 'flat', 'Style','checkbox' ));
ET6han  = sort(findobj(CHD6han, 'flat', 'Style','edit' ));
               
if ( Action == 1 )       % === Polynomial ====

   set( RBhan([2 3]), 'Value', 0 ); 
   set( RBhan(1), 'Enable', 'on', 'Value', 1 );
   set( RBhan(2), 'Enable', 'on' );
   set( [RBhan([4 5]); LBhan], 'Enable', 'off');
   
elseif ( Action == 2 )       % === Lattice ======

   set( RBhan([1 3]), 'Value', 0 ); 
   set(  RBhan(2), 'Value', 1 );
   set( [RBhan([4 5]); LBhan] , 'Enable', 'off' );

elseif ( Action == 3 )       % === SoS ======

   set(  RBhan([1 2]), 'Value', 0 ); set( RBhan(3), 'Value', 1 );
   set( [RBhan([4 5]); LBhan] , 'Enable', 'on' );

elseif ( Action == 4 )       % === Yes ====

   set( RBhan(5), 'Value', 0 ); set( RBhan(4), 'Value', 1 );

elseif ( Action == 5 )       % === No ====

   set( RBhan(4), 'Value', 0 ); set( RBhan(5), 'Value', 1 );

elseif ( Action == 6 )       % === Two's comp ====

   set( RBhan(7), 'Value', 0 ); set( RBhan(6), 'Value', 1 );

elseif ( Action == 7 )       % === Unsigned Integer ====

   set( RBhan(6), 'Value', 0 ); set( RBhan(7), 'Value', 1 );

elseif ( Action == 8 )       % === FLOATING/FIXED POINT ====

   h = findobj(CHLDhan,'flat','Style','popupmenu');
   g = findobj(CHLDhan,'flat','Tag',  'fixed'    );
   if ( nargin == 1 )
      coef_type =  get( h, 'Value' );
   else
      coef_type = arg2;
   end
   if ( coef_type == 1 )     % === float ===
      set( h, 'Enable', 'on',   'Value', 1 );
      set( g, 'Enable', 'off' );
   else 
      set( h, 'Value',   2   );
      set( g, 'Enable', 'on' );
   end

elseif ( Action == 10 )       % === Enable/Disable Lattice & SoS ====

   if ( DFP_fir )
      EnableFlag = 'off';
   else
      EnableFlag = 'on';
   end
   set( [RBhan([3 4 5]); LBhan; CB6han(3); ET6han(3)], 'Enable', EnableFlag );

end

