function FIGhan = d_propts()
%D_PROPTS creates and initializes the "PROPERTIES" window and its children.
%
%         FIG = D_PROPTS returns the handle to the figure object which has 
%         been created by calling the function D_PROPTS.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global   DFP_ColorMonitor

%==============
% FIGURE NUMBER
%==============
FigNo = 8;

[ Flag, Fig ] = figflag( d_namesv(FigNo), 0 );

if ( Flag )
   FIGhan = Fig;
   return;
end

if ( DFP_ColorMonitor )

   FIGhan = d_proclr;

else

   FIGhan = d_probaw;

end
