function d_propsv()
%D_PROPSV saves the customizable parameters to the file DFPRC.M
%
%         This function accesses the present values of the customizable 
%         parameters, opens the file DFPRC.M and writes the parameters.
%         Next time when DFP starts these parameters will be used.
%         Any existing DFPRC.M will be overwritten.  DFPRC.M is time/date
%         stamped.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global DFP_AXbgroundcolor  DFP_TARGETcolor     DFP_MAGcolor     ...
       DFP_PHASEcolor      DFP_POLEcolor       DFP_ZEROcolor    ...   
       DFP_Directory       DFP_SourceCodeDir   DFP_TemplatesDir ...
       DFP_FREQZpoints     DFP_FigureResize    DFP_POLEZEROaxis

FileName = [ DFP_Directory 'dfprc.m' ];
FileName = FileName( ~isspace(FileName) );
fid = fopen( FileName, 'w+' );

if ( fid > 0 )

   fprintf( fid, '%%=======================================\n' );
   fprintf( fid, '%%  DFPRC.M:                             \n' );
   fprintf( fid, '%%  DFP properties initialization script \n' );
   fprintf( fid, '%%  Created on: %s\n', timedate              );
   fprintf( fid, '%%=======================================\n' );
   fprintf( fid, '\n' ); 
   fprintf( fid, '%% Color definitions\n' );
   fprintf( fid, '%%==================\n' );
   fprintf( fid, 'DFP_AXbgroundcolor = [%g %g %g];\n', DFP_AXbgroundcolor);
   fprintf( fid, 'DFP_TARGETcolor    = [%g %g %g];\n', DFP_TARGETcolor);
   fprintf( fid, 'DFP_MAGcolor       = [%g %g %g];\n', DFP_MAGcolor );
   fprintf( fid, 'DFP_PHASEcolor     = [%g %g %g];\n', DFP_PHASEcolor );;
   fprintf( fid, 'DFP_POLEcolor      = [%g %g %g];\n', DFP_POLEcolor );
   fprintf( fid, 'DFP_ZEROcolor      = [%g %g %g];\n', DFP_ZEROcolor );
   fprintf( fid, 'DFP_POLEZEROaxis   = [%g %g %g];\n', DFP_POLEZEROaxis );
   fprintf( fid, '\n' ); 
   fprintf( fid, '%% Directories\n' );
   fprintf( fid, '%%==================\n' );
   fprintf( fid, 'DFP_Directory      = ''%s'';\n', DFP_Directory );
   fprintf( fid, 'DFP_SourceCodeDir  = ''%s'';\n', DFP_SourceCodeDir );
   fprintf( fid, 'DFP_TemplatesDir   = ''%s'';\n', DFP_TemplatesDir );
   fprintf( fid, '\n' ); 
   fprintf( fid, '%%  Other     \n' );
   fprintf( fid, '%%==================\n' );
   fprintf( fid, 'DFP_FREQZpoints    = %i;\n',     DFP_FREQZpoints );
   fprintf( fid, 'DFP_FigureResize   = ''%s'';\n', DFP_FigureResize );

   status = fclose( fid );
   if ( status )
      d_error( 'EG-04', FileName )  %======  File closing error
   end

else

   d_error( 'EG-03', FileName )     %======  File opening error

end
