function FIGhan = d_proclr()
%D_PROCLR creates and initializes the "PROPERTIES" window and its children
%         for color monitors
%
%         FIG = D_PROCLR returns the handle to the figure object which has 
%         been created by calling the function D_PROPTS.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

%=================
% GLOBAL variables
%=================
global   DFP_ETbgroundcolor  DFP_WinBorderOffset  DFP_Offset3         ...
         DFP_Frame2button    DFP_UIcontrolBox_X   DFP_UIcontrolBox_Y  ...
         DFP_AXbgroundcolor  DFP_POLEZEROaxis     DFP_TARGETcolor     ...
         DFP_MAGcolor        DFP_PHASEcolor       DFP_POLEcolor       ...
         DFP_ZEROcolor       DFP_FREQZpoints      DFP_POLEZEROaxis    ...
         DFP_Directory       DFP_SourceCodeDir    DFP_TemplatesDir    ...
         DFP_FigureResize    DFP_UIbgroundcolor   DFP_ScaleX          ...
         DFP_ScaleY


%==============
% FIGURE NUMBER
%==============
FigNo = 8;


% Dimension definitions (local)
%==============================
Dim11 = 1;                  % FR to l/r FIG edge
Dim12 = 1;                  % FR to b FIG edge
Dim13 = 1;                  % FR to t FIG edge

Dim22 = 0;                  % Separation between the lower FR and PB FR

Dim4  = 4*DFP_Frame2button; % Ver Separation top FR --> top RB
Dim41 = 4*DFP_Frame2button; % Ver Separation bot FR --> bot RB
Dim6  = 4*DFP_Frame2button; % Ver Separation top RB --> bottom long PU
Dim7  = 4*DFP_Frame2button; % Hor Separation RB --> short ETs
Dim9  = 20*DFP_ScaleY;      % PB to lower FR top and bottom

UIx   = (60*DFP_ScaleX)+DFP_UIcontrolBox_X;      % expanded UI width

TXx   = UIx;                        % TEXT object width
TXy   = DFP_UIcontrolBox_Y;         % TEXT object height

ETx   = UIx;                        % EDITABLE TEXT object width
ETy   = DFP_UIcontrolBox_Y - 2;     % EDITABLE TEXT object height

RBx   = UIx;                        % RADIOBUTTON object width
RBy   = DFP_UIcontrolBox_Y;         % RADIOBUTTON object height

PBx   = DFP_UIcontrolBox_X;         % PUSHBUTTON object width
PBy   = DFP_UIcontrolBox_Y;         % PUSHBUTTON object height

PUx1  = UIx;                        % small POP-UP MENU object width
PUy1  = DFP_UIcontrolBox_Y;         % small POP-UP MENU object height
PUx   = DFP_UIcontrolBox_X*2.5;     % large POP-UP MENU object width
PUy   = DFP_UIcontrolBox_Y*1.2;     % large POP-UP MENU object height

%
%  FRAME objects
%===============
FRx   = 3*Dim7 + 2*UIx;
FRy1  = 7*RBy + PUy + Dim6 + 2*Dim41 + 3*ETy + Dim4;
FRyp  =   PBy + 2*Dim9;

FRpos = [
          Dim11   Dim12+FRyp+Dim22             FRx  FRy1;
          Dim11   Dim12                        FRx  FRyp;
        ];

%
% RADIOBUTTON  objects
%=======================
RBpos = [
          (FRpos(1,1)+Dim7)*ones(7,1)                ...
          (FRpos(1,2)+2*Dim41+3*ETy)*ones(7,1)+RBy*[6:-1:0]' ...
           RBx*ones(7,1)                             ...
           RBy*ones(7,1)                             ...
        ];
RBstr = str2mat( 'Axes',             ...
                 'Target',           ...
                 'Magnitude',        ...
                 'Phase/GD/Impulse', ...
                 'Pole',             ...
                 'Zero',             ...
                 'Pole/Zero Axis'       );
RBfgc = [
          DFP_AXbgroundcolor;
          DFP_TARGETcolor;
          DFP_MAGcolor;
          DFP_PHASEcolor;
          DFP_POLEcolor;
          DFP_ZEROcolor;
          DFP_POLEZEROaxis;
        ];

RBbgc = DFP_UIbgroundcolor(ones(7,1),:);

%
% TEXT  objects
%=======================
TXpos = [ 
          RBpos(1,1)*ones(3,1) RBpos(1:2:5,2)-2 TXx*ones(3,1) TXy*ones(3,1);
          ...
          RBpos(3,1) RBpos(3,2)+RBy/2  TXx+3*Dim7 TXy;
          RBpos(4,1) RBpos(4,2)-RBy/2  TXx+3*Dim7 TXy;
        ];

TXstr = str2mat('DFP Directory:', ...
                'Source Code Directory:', ...
                'DSP Code Templates:', ...
                'Frequency Response Points', ...
                'Resizable Figures?' );
TXtag = str2mat( 'dir', 'dir', 'dir', 'other', 'other' );

%
% POPUPmenu  objects
%=======================
PUpos = [
          FRpos(1,1)+FRx/2-PUx/2    RBpos(1,2)+RBy+Dim6       PUx  PUy;
          sum(RBpos(1,[1 3]))+Dim7  RBpos(3,2)+(3*DFP_ScaleY) PUx1 PUy1;
          TXpos(5,1)+3*Dim7+UIx     TXpos(5,2)         PUx1-2*Dim7 PUy1;
        ];

ColorStr = ...
      'Yellow|Magenta|Cyan|Red|Green|Blue|White|Black|Slate Blue|Other ...';
PUstr = str2mat( 'DISPLAY Colors|Directories|Other' , ColorStr, 'Off|On' );
PUval = [ 1  1  1 ];
if ( strcmp(DFP_FigureResize,'on') )
   PUval(3) = 2;
end
PUtag = str2mat( '', 'color', 'other' );
PUcb  = str2mat( 'd_prclcb(1)', 'd_prclcb(2)', ...
                 'd_prclcb(14)' );
PUvis = str2mat( 'on', 'on', 'off' );

%
%  EDITABLE TEXT objects
%=======================
dim = FRx - 2*Dim7;

ETpos = [ 
          sum(RBpos(1,[1 3]))+Dim7  RBpos(4,2)-(3*DFP_ScaleY)  ETx  ETy ;
          FRpos(1,1)+Dim7           FRpos(1,2)+Dim41           dim  3*ETy;
          RBpos(2:2:6,1)+Dim7       RBpos(2:2:6,2) 2*ETx*ones(3,1)  ...
                                                            ETy*ones(3,1);
          TXpos(4,1)+3*Dim7+UIx     TXpos(4,2)          ETx-2*Dim7  ETy;
        ];

ETtag = str2mat( 'color_other', 'help',    'dir', 'dir', 'dir', 'other' );
ETvis = str2mat( 'off',         'on',  'off', 'off', 'off', 'off' );
ETstr = str2mat( ' ', '', ...
                 DFP_Directory, DFP_SourceCodeDir, DFP_TemplatesDir, ...
                 [ ' ' num2str(DFP_FREQZpoints)] );
ETalg = str2mat( 'left', 'center', 'left', 'left', 'left', 'left' );
ETmax = [ 1 2 1 1 1 1 ];
ETcb  = str2mat( '', '', 'd_prclcb(10);', ...
                         'd_prclcb(11);', ...
                         'd_prclcb(12);', ...
                         'd_prclcb(13);'     );
%
% PUSHBUTTON  objects
%=======================
dim    = (FRx - 3*PBx)/4;
PBpos = [
          FRpos(2,1)+  dim       FRpos(2,2)+Dim9   PBx    PBy ;
          FRpos(2,1)+2*dim+PBx   FRpos(2,2)+Dim9   PBx    PBy ;
          FRpos(2,1)+3*dim+2*PBx FRpos(2,2)+Dim9   PBx    PBy ;
        ];
PBcb  = str2mat( 'd_prclcb(15);',  ...
                 'd_rstdef(1);' , ...
                 'set(gcf,''Visible'',''off'')' );
PBstr = str2mat( 'Save', 'Cancel' , 'Close' );

%===============
%  Create FIGURE
%===============
REFpos = get(findobj(get(0,'children'),'flat','Tag','fig1'),'Position');
FIGx   = FRx + 2*Dim11;
FIGy   = FRyp + Dim12 + Dim13 + Dim22 + FRy1;
FIGpos = [ DFP_WinBorderOffset+REFpos(1) REFpos(2)-FIGy-DFP_Offset3];
FIGhan = figure( ...
                'Position',     [FIGpos FIGx FIGy],        ...
                'Name',          d_namesv(FigNo),          ...
                'MenuBar',      'none',                    ...
                'Color',         DFP_UIbgroundcolor,       ...
                'Visible',      'off',                     ...
                'Backingstore', 'off',                     ...
                'Tag',          ['fig' num2str(FigNo)],    ...
                'NextPlot',     'new',                     ...
                'UserData',      1,                        ...
                'Resize',        DFP_FigureResize,         ...
                'NumberTitle',  'off'                      ...
                );

%============================
% Create and place UI objects
%============================
%
% FRAME objects
%==============
for ii = 1:size(FRpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'Frame',              ...
              'Position',             FRpos(ii,:) );
end

%
%  POP-UP MENU objects
%=======================
for ii = 1:size(PUpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'popupmenu',          ...
              'HorizontalAlignment', 'center',             ...
              'Position',             PUpos(ii,:),         ...
              'Tag',                  deblank(PUtag(ii,:)),...
              'String',               deblank(PUstr(ii,:)),...
              'Callback',             deblank(PUcb(ii,:)), ...
              'Value',                PUval(ii),           ...
              'Visible',              deblank(PUvis(ii,:)) ...
             );
end

%
% RADIOBUTTON objects
%===================
for ii = 1:size(RBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'pushbutton',         ...
              'ForegroundColor',      RBfgc(ii,:),         ...
              'BackgroundColor',      RBbgc(ii,:),         ...
              'HorizontalAlignment', 'center',             ...
              'Callback',             sprintf('d_prclcb(%i)',2+ii),...
              'Tag',                 'color',              ...
              'Position',             RBpos(ii,:),         ...
              'String',               deblank(RBstr(ii,:)) ...
              );
end

%
%  TEXT objects
%==============
for ii = 1:size(TXpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'text',               ...
              'HorizontalAlignment', 'left',               ...
              'Position',             TXpos(ii,:),         ...
              'Tag',                  deblank(TXtag(ii,:)),...
              'Visible',             'off',                ...
              'String',               deblank(TXstr(ii,:)) ...
              );
end

%
%  EDITABLE TEXT objects
%=======================
for ii = 1:size(ETpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'Edit',               ...
              'Position',             ETpos(ii,:),         ...
              'Visible',              deblank(ETvis(ii,:)),...
              'String',               deblank(ETstr(ii,:)),...
              'Tag',                  deblank(ETtag(ii,:)),...
              'Min',                  0,                   ...
              'Max',                  ETmax(ii),           ...
              'Callback',             deblank( ETcb(ii,:)),...
              'HorizontalAlignment',  deblank(ETalg(ii,:)),...
              'BackGroundColor',      DFP_ETbgroundcolor   ...
             );
end

%
% PUSHbutton objects
%===================
for ii = 1:size(PBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'pushbutton',         ...
              'HorizontalAlignment', 'center',             ...
              'Position',             PBpos(ii,:),         ...
              'Callback',             deblank( PBcb(ii,:)),...
              'String',               deblank(PBstr(ii,:)) ...
              );
end

d_prclcb(1);
set(gcf,'visible','on');
