function  d_propcb( Action )
%D_PROPCB is the callback function for the "PROPERTIES" window.
%
%         D_PROPCB( ACTION ) implements the callback associated with ACTION.
%         ACTION = 1 : callback for the top main pop-up-menu.  According to
%                      selected options in sets up the UICONTROL objects.
%                  2 : callback for the COLORS pop-up-menu in the 1st screen
%                3-9 : callbacks for the radiobuttons in the 1st screen.  When
%                      a radiobutton is pressed this callback will update the
%                      color of the object connected to the radiobutton 
%                      according the color specification.
%               10-12: callbacks for the editable texts in the 2nd screen.
%                  13: callback for the FREQ RESPONSE POINTS editable text
%                      in the 3rd screen.
%                  14: callback for RESIZE On/Off pop-up-menu in the 3rd screen.
%                  15: callback for the SAVE pushbutton, calls D_PROPSV.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global DFP_AXbgroundcolor  DFP_TARGETcolor     DFP_MAGcolor     ...
       DFP_PHASEcolor      DFP_POLEcolor       DFP_ZEROcolor    ...   
       DFP_Directory       DFP_SourceCodeDir   DFP_TemplatesDir ...
       DFP_FREQZpoints     DFP_FigureResize    DFP_POLEZEROaxis

FIG8han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig8' );
CHLDhan = get( FIG8han, 'Children' );
PUhan   = sort( findobj(CHLDhan,'flat','Style','popupmenu') );
PBhan   = sort( findobj(CHLDhan,'flat','Style','pushbutton'));
EThan   = sort( findobj(CHLDhan,'flat','Style','edit'));
HLPhan  = EThan(2);

rgb = [ 1 1 0; 1 0 1; 0 1 1; 1 0 0; 0 1 0; 0 0 1; 1 1 1; 0 0 0; ...
        [71 60 139 ]/256 ];

str1 = sprintf( ...
           [ ' Change the colors of selected objects indicated by\n'  ...
             ' the pushbuttons on the left and the color selection\n' ...
             ' pop-up menu on the right of the screen.\n' ]           ...
           );
str2 = sprintf( ...
           [ ' Specify (1) the directory to be used by the DFP;\n'    ...
             ' (2) the location of source files to be generated;\n'   ...
             ' (3) where the DSP code template files reside.\n' ]     ...
           );
str3 = sprintf( ...
           [ ' Enter the number of points the MATLAB function\n'      ...
             ' "freqz" should use to evaluate the frequency\n'        ...
             ' response functions.\n' ]                               ...
           );
str4 = sprintf( ...
           [ ' Enter the desired color as an RGB triplet.  Each\n'    ...
             ' element of the RGB triplet must be between 0 and 1.\n' ...
             ' For example: [ 0.1 0.2 1  ].\n' ]                      ...
           );
str5 = sprintf( ...
           [ ' Change the colors of selected objects indicated by\n'  ...
             ' the pushbuttons on the left and the color selection\n' ...
             ' pop-up menu on the right of the screen.\n' ]           ...
           );
str6 = sprintf( ...
           [ ' Select the "Yes" option if you want to be able to\n'   ...
             ' resize the figures.\n' ]                               ...
           );

filesep = '/';
c = computer;
if strcmp(c(1:2),'PC')
   filesep = '\';
elseif strcmp(c(1:2),'MA')
   filesep = ':';
elseif isvms
   filesep = '.]';
end

if ( Action == 1 )

   PUvalue = get( PUhan(1), 'Value' );

   if ( PUvalue == 1 )   %=== Colors
      
      OnHandles  = findobj(CHLDhan,'flat','Tag','color');
      OffHandles = [ findobj(CHLDhan,'flat','Tag','dir'); ...
                     findobj(CHLDhan,'flat','Tag','other') ];
      str = str1;

   elseif ( PUvalue == 2 )   %=== Directories

      OnHandles  =   findobj(CHLDhan,'flat','Tag','dir'  );
      OffHandles = [ findobj(CHLDhan,'flat','Tag','color'); ...
                     findobj(CHLDhan,'flat','Tag','other'); ...
                     findobj(CHLDhan,'flat','Tag','color_other') ];
      str = str2;

   elseif ( PUvalue == 3 )   %=== Other

      OnHandles  =   findobj(CHLDhan,'flat','Tag','other');
      OffHandles = [ findobj(CHLDhan,'flat','Tag','color'); ...
                     findobj(CHLDhan,'flat','Tag','color_other'); ...
                     findobj(CHLDhan,'flat','Tag','dir'  ) ];
      str = str3;

   end  

   set( OffHandles, 'Visible', 'off' );
   set(  OnHandles, 'Visible', 'on'  );
   set(  findobj(CHLDhan,'flat','Style','edit','Tag','help'), 'String', '');
   set( PUhan(2), 'Value', 1 );
   set( HLPhan, 'String', str );

elseif ( Action == 2 )

   PUvalue = get( PUhan(2), 'Value' );
   FIG4han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig4' );

   if ( PUvalue == 10 )   
      Flag = 'on';
      str = str4;
   else
      Flag = 'off';
      str = str5;
   end
  
   set(findobj(CHLDhan,'flat','Style','edit','Tag','color_other'), ...
          'Visible', Flag );
   set( HLPhan, 'String', str );

elseif ( sum(Action == [3:9]) )  %=== RADIOBUTTON callbacks

   PUvalue = get( PUhan(2), 'Value' );
   FIG4han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig4' );

   if ( sum(PUvalue == [1:9]) )
      Color = rgb( PUvalue, :);
   else
      str = ...
      get(findobj(CHLDhan,'flat','Style','edit','Tag','color_other'),'String');
      s   = str2num( [ '[' str ']' ] );
      if ( isempty(s) )
         d_error( 'EP-02', str )
         return
      elseif ( any([(s<0)|(1<s)]) ) 
         d_error( 'EP-02', str )
         return
      else
         Color = s;
      end
   end

   if ( Action == 3 )  %=== AXES radiobutton

      set( PBhan(1), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'flat','Type','axes'), ...
                 'Color', Color );
      set( FIG4han, 'DefaultAxesColor', Color );
      DFP_AXbgroundcolor = Color;

   elseif ( Action == 4 )  %=== TARGET radiobutton

      set( PBhan(2), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'Type','line', ...
                       'Tag','plot:target'), 'Color', Color );
      DFP_TARGETcolor = Color;

   elseif ( Action == 5 )  %=== MAGNITUDE radiobutton

      set( PBhan(3), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'Type','line', ...
                       'Tag','plot:mag'), 'Color', Color );
      DFP_MAGcolor = Color;

   elseif ( Action == 6 )  %=== PHASE/GD/IMPULSE radiobutton

      set( PBhan(4), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'Type','line', ...
                       'Tag','plot:pha'), 'Color', Color );
      DFP_PHASEcolor = Color;

   elseif ( Action == 7 )  %=== POLE radiobutton

      set( PBhan(5), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'Type','line', ...
              'LineStyle','x','Tag','plot:poz'), 'Color', Color );
      DFP_POLEcolor = Color;

   elseif ( Action == 8 )  %=== ZERO radiobutton

      set( PBhan(6), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'Type','line', ...
              'LineStyle','o','Tag','plot:poz'), 'Color', Color );
      DFP_ZEROcolor = Color;

   elseif ( Action == 9 )  %=== POLE/ZERO axis

      set( PBhan(7), 'ForegroundColor', Color ); 
      set( findobj(get(FIG4han,'Children'),'Type','line', ...
              'LineStyle',':','Tag','plot:poz'), 'Color', Color );
      DFP_POLEZEROaxis = Color;

   end

elseif ( sum(Action == [10:12]) )  %=== DIRECTORY ET callbacks

      if ( Action == 10 )      %===  DFP_Directory 
         HaIndex = 3;
         VarName = 'DFP_Directory';
      elseif ( Action == 11 )  %===  DFP_SourceCodeDir 
         HaIndex = 4;
         VarName = 'DFP_SourceCodeDir';
      elseif ( Action == 12 )  %===  DFP_TemplatesDir 
         HaIndex = 5;
         VarName = 'DFP_TemplatesDir';
      end

      s = deblank( get(EThan(HaIndex),'String') );
      s = s( ~isspace(s) ); %== eliminate leading blanks or it does not work
      if ( isempty(s) )
         eval( [ VarName ' = '''';' ] ) %== blank, i.e., "./"
      else
         if ( ~isdir(s) )
            d_error('EG-01',s);
            return
         end
         if ( strcmp(filesep,s(length(s))) )
            eval( [ VarName ' = '''  s ''';' ] )
         else
            d_error('EG-05',s);
         end
      end

elseif ( Action == 13 )  %===  DFP_FREQZpoints

      set( HLPhan, 'String', str3 );
      str = get(EThan(6),'String');
      no  = str2num( str );
      if ( isempty(no) )
         d_error( 'EP-03', str )
         return
      else
         DFP_FREQZpoints = no;
      end

elseif ( Action == 14 )  %=== Resize Figures?

      set( HLPhan, 'String', str6 );
      idx = get(PUhan(3),'Value');
      if ( idx == 1)
         DFP_FigureResize = 'off';
         set( get(0,'Children'), 'Resize', 'off' );
      else
         DFP_FigureResize = 'on';
         set( get(0,'Children'), 'Resize', 'on' );
      end

elseif ( Action == 15 )  %=== SAVE

      d_propsv;

end
