function FIGhan = d_output()
%D_OUTPUT creates and initializes the "OUTPUT" window and its children.
%
%         FIG = D_OUTPUT returns the handle to the figure object which has 
%         been created by calling the function D_OUTPUT.  

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

%=================
% GLOBAL variables
%=================
global   DFP_ETbgroundcolor  DFP_WinBorderOffset  DFP_Frame2button    ...
         DFP_UIcontrolBox_X  DFP_UIcontrolBox_Y   DFP_Offset3         ...
         DFP_SlateBluecolor  DFP_FigureResize     DFP_UIbgroundcolor  ...
         DFP_ScaleX          DFP_ScaleY

DFP_PUstrArray = str2mat( 'Do not generate code|Motorola DSP56k Assembler',...
                          '', '', '' );

%==============
% FIGURE NUMBER
%==============
FigNo = 6;

%
% Dimension definitions (local)
%==============================
Dim11 = 1;                  % FR to l/r FIG edge
Dim12 = 1;                  % FR to b FIG edge
Dim13 = 1;                  % FR to t FIG edge

Dim21 = 0;                  % Separation between upper two FRs
Dim22 = 0;                  % Separation between the lower FR and PB FR

Dim3  = 2*DFP_Frame2button; % From top of Label FR to the top of Big FR
Dim4  = 3*DFP_Frame2button; % Ver Separation bot mid FR --> bot of long ET
Dim41 = 4*DFP_Frame2button; % Ver Separation bot FR --> bot CB
Dim5  = DFP_Frame2button/2; % Ver Separation top CB --> bottom label TX
Dim6  = 4*DFP_Frame2button; % Ver Separation top short PU --> bot long PU
Dim7  = 4*DFP_Frame2button; % Hor Separation CB --> short ETs
Dim8  = 2*DFP_ScaleX;       % Blue TX separation from Label FR edges
Dim9  = 20 * DFP_ScaleY;    % PB to lower FR top and bottom
DimA  = Dim7;               % Hor Separation Label TX --> small PU and long ET
DimB  = DFP_Frame2button;   % Ver Separation long ET --> lower small PU

UIx   = (60*DFP_ScaleX)+DFP_UIcontrolBox_X;      % expanded UI width

TXx   = UIx;                        % TEXT object width
TXx1  = DFP_UIcontrolBox_X;         % narrower Label TXs in the "Generate" FR
TXy   = DFP_UIcontrolBox_Y;         % TEXT object height

ETx   = UIx;                        % EDITABLE TEXT object width
ETx1  = 2*UIx + Dim7 - TXx1 - DimA; % EDITABLE TEXT object width
ETy   = DFP_UIcontrolBox_Y - (4*DFP_ScaleY);   % ET object height

CBx   = UIx;                        % CHECKBOX object width
CBy   = DFP_UIcontrolBox_Y;         % CHECKBOX object height

PBx   = DFP_UIcontrolBox_X;         % PUSHBUTTON object width
PBy   = DFP_UIcontrolBox_Y;         % PUSHBUTTON object height

PUx1  = 2*UIx + Dim7 - TXx1 - DimA; % small POP-UP MENU object width
PUy1  = DFP_UIcontrolBox_Y;         % small POP-UP MENU object height
PUx   = DFP_UIcontrolBox_X*2.5;     % large POP-UP MENU object width
PUy   = DFP_UIcontrolBox_Y*1.2;     % large POP-UP MENU object height

%
%  FRAME objects
%===============
FRTXx =   Dim7 + CBx + ETx;
FRTXy =   TXy + 2*Dim8;

FRx   =   3*Dim7 + CBx + ETx; 
FRy2  =   Dim3 + Dim41 + Dim4 + Dim5 + 3*CBy +   TXy + FRTXy;
FRy1  =   Dim3 + 2*Dim6  + Dim4 +  PUy  + 3*TXy + FRTXy + DimB;
FRyp  =   PBy + 2*Dim9;

FRpos = [
          Dim11   Dim12+FRyp+Dim22+FRy1+Dim21  FRx  FRy2;
          Dim11   Dim12+FRyp+Dim22             FRx  FRy1;
          Dim11   Dim12                        FRx  FRyp;
        ];
FRpos = [
          FRpos; 
          ...
          Dim11+Dim7 FRpos(1,2)+Dim41+3*CBy+Dim5+TXy+Dim4      FRTXx FRTXy;
          Dim11+Dim7 FRpos(2,2)+Dim4+3*TXy+Dim6+PUy+Dim41+DimB FRTXx FRTXy;
        ];
          
%
% CHECKBOX  objects
%=======================
CBpos = [
          (FRpos(1,1)+Dim7)*ones(3,1)                ...
          (FRpos(1,2)+Dim41)*ones(3,1)+CBy*[2:-1:0]' ...
           CBx*ones(3,1)                             ...
           CBy*ones(3,1)                             ...
        ];
CBstr = str2mat( 'Polynomial',   'Lattice',     '2nd Order Sections' );
CBtag = str2mat( 'fig6:cb_poly', 'fig6:cb_lat', 'fig6:sos'        );
CBenb = str2mat( 'on', 'off', 'off' );

%
% TEXT  objects
%=======================
TXpos = [
          CBpos(1,1)            CBpos(1,2)+CBy               TXx   TXy;
          CBpos(1,1)+CBx+Dim7   CBpos(1,2)+CBy               TXx   TXy;
          FRpos(4,:)+[2 0 -5 0]*DFP_ScaleX+[0 3 0 -5]*DFP_ScaleY; 
          ...
          FRpos(2,1)+Dim7       FRpos(2,2)+Dim4              TXx1  TXy;
          FRpos(2,1)+Dim7       FRpos(2,2)+Dim4+2*TXy+DimB   TXx1  TXy;
          FRpos(5,:)+[2 0 -5 0]*DFP_ScaleX+[0 3 0 -5]*DFP_ScaleY; 
        ];
TXstr = str2mat( 'Which Coefficients?',          ...
                 'Array Name(s)',                ...
                 'Transfer to MATLAB Workspace', ...
                 'File Name',                    ...
                 'Options',                      ...
                 'Generate Filter Code' );
TXbgc = [ 
          DFP_UIbgroundcolor;
          DFP_UIbgroundcolor;
          DFP_SlateBluecolor;
          DFP_UIbgroundcolor;
          DFP_UIbgroundcolor;
          DFP_SlateBluecolor;
        ];
TXfgc = [ 
          0 0 0;
          0 0 0;
          1 1 1;
          0 0 0;
          0 0 0;
          1 1 1;
        ];
TXalg = str2mat( 'center', 'center', 'center', 'left', 'left', 'center' );
TXtag = str2mat( '', '', '', 'fig6:filtercode', 'fig6:filtercode', '' );
TXenb = str2mat( 'on', 'on', 'on', 'off', 'off', 'on' );

%
%  EDITABLE TEXT objects
%=======================
ETpos = [
          CBpos(:,1)+Dim7+CBx   CBpos(:,2)+(2*DFP_ScaleY) ...
                                           ETx*ones(3,1)  ETy*ones(3,1);
          TXpos(4,1)+DimA+TXx1  TXpos(4,2) ETx1-(ETy+8)   ETy+(4*DFP_ScaleY);
        ];
ETstr = str2mat( ' num, den' ,           ...
                 ' refl_coeff, c_coeff', ...
                 ' sos_array, gain'    , ...
                 ' '                        );
ETtag = str2mat( 'fig6:et_poly', 'fig6:et_lat', 'fig6:sos', 'fig6:filtercode');
ETalg = str2mat( 'left', 'left', 'left', 'right' );
ETenb = str2mat( 'on', 'off', 'off', 'off' );
ETcb  = str2mat( 'd_outpcb(3)', ...
                 'd_outpcb(4)', ...
                 'd_outpcb(5)', '' );

%
% PUSHBUTTON  objects
%=======================
aa    = (FRx - 2*PBx)/3;
bx    = 4*DFP_ScaleX;
by    = 4*DFP_ScaleY;
PBpos = [
          FRpos(3,1)+  aa        FRpos(3,2)+Dim9   PBx     PBy ;
          FRpos(3,1)+2*aa+PBx    FRpos(3,2)+Dim9   PBx     PBy ;
          sum(ETpos(4,[1 3]))+bx ETpos(4,2)        ETy+bx  ETy+by;
        ];
PBcb  = str2mat( 'd_transf; d_outpcb(6)',        ...
                 'd_navgcb(11,0)' , ...
                 'd_outpcb(2)'             );
PBstr = str2mat( 'Apply',  'Close',  '...'             );
PBtag = str2mat( '',       '',       'fig6:filtercode' );
PBenb = str2mat( 'on',     'on',     'off'             );


%
%  POP-UP MENU objects
%=======================
PUpos = [
          FRpos(2,1)+FRx/2-PUx/2  TXpos(5,2)+TXy+Dim6  PUx    PUy;
          TXpos(5,1)+DimA+TXx1*ones(2,1)                            ...
                                  TXpos(5,2)*ones(2,1)-PUy1*[0:1]'  ...
                                                   PUx1*ones(2,1)   ...
                                                   PUy1*ones(2,1);
        ];

PUstr = DFP_PUstrArray; 
PUalg = str2mat( 'center',      'left',  'left' ); 
PUenb = str2mat( 'off',         'off',   'off'  ); 
PUcb  = str2mat( 'd_outpcb(1)', '',      ''     ); 

%===============
%  Create FIGURE
%===============
REFpos = get(findobj(get(0,'children'),'flat','Tag','fig1'),'Position');
FIGx   = FRx + 2*Dim11;
FIGy   = FRyp + Dim12 + Dim13 + Dim21 + Dim22 + FRy1 + FRy2;
FIGpos = [ DFP_WinBorderOffset+REFpos(1) REFpos(2)-FIGy-DFP_Offset3]; 
FIGhan = figure( ...
                'Position',     [FIGpos FIGx FIGy],        ...
                'Name',          d_namesv(FigNo),          ...
                'MenuBar',      'none',                    ...
                'Color',         DFP_UIbgroundcolor,       ...
                'Visible',      'off',                     ...
                'Resize',        DFP_FigureResize,         ...
                'Backingstore', 'off',                     ...
                'Tag',         ['fig' num2str(FigNo)],     ...
                'NextPlot',     'new',                     ...
                'UserData',      1,                        ...
                'NumberTitle',  'off'                      ...
                );

%============================
% Create and place UI objects
%============================
%
% FRAME objects
%==============
for ii = 1:size(FRpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'Frame',              ...
              'Position',             FRpos(ii,:) );
end

%
%  TEXT objects
%==============
for ii = 1:size(TXpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'text',               ...
              'HorizontalAlignment',  deblank(TXalg(ii,:)),...
              'Position',             TXpos(ii,:),         ...
              'BackGroundColor',      TXbgc(ii,:),         ...
              'Tag',                  deblank(TXtag(ii,:)),...
              'Enable',               TXenb(ii,:),         ...
              'ForegroundColor',      TXfgc(ii,:),         ...
              'String',               deblank(TXstr(ii,:)) ...
              );
end

%
%  POP-UP MENU objects
%=======================
for ii = 1:size(PUpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'popupmenu',          ...
              'HorizontalAlignment', 'center',             ...
              'Position',             PUpos(ii,:),         ...
              'Callback',             deblank(PUcb(ii,:)), ...
              'Tag',                 'fig6:filtercode',    ...
              'Enable',               PUenb(ii,:),         ...
              'String',               deblank(PUstr(ii,:)) ...
             );
    end

%
%  EDITABLE TEXT objects
%=======================
for ii = 1:size(ETpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'Edit',               ...
              'HorizontalAlignment',  deblank(ETalg(ii,:)),...
              'String',               deblank(ETstr(ii,:)),...
              'Position',             ETpos(ii,:),         ...
              'Enable',               ETenb(ii,:),         ...
              'Tag',                  deblank(ETtag(ii,:)),...
              'Callback',             deblank(ETcb(ii,:)), ...
              'BackGroundColor',      DFP_ETbgroundcolor   ...
             );
end

%
% CHECKBOX objects
%===================
for ii = 1:size(CBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'checkbox',           ...
              'HorizontalAlignment', 'left',               ...
              'Enable',               CBenb(ii,:),         ...
              'Tag',                  deblank(CBtag(ii,:)),...
              'Callback',             sprintf('d_outpcb(%i)',2+ii),...
              'Position',             CBpos(ii,:),         ...
              'String',               deblank(CBstr(ii,:)) ...
              );
end

%
% PUSHbutton objects
%===================
for ii = 1:size(PBpos,1)
    uicontrol( FIGhan,                                     ...
              'Style',               'pushbutton',         ...
              'HorizontalAlignment', 'center',             ...
              'Position',             PBpos(ii,:),         ...
              'Enable',               PBenb(ii,:),         ...
              'Tag',                  deblank(PBtag(ii,:)),...
              'Callback',             deblank( PBcb(ii,:)),...
              'String',               deblank(PBstr(ii,:)) ...
              );
end

set( get(FIGhan,'Children'), 'Units', 'normalized' );
