function  d_outpcb( Action )
%D_OUTPCB is the callback function for the "OUTPUT" window.
%
%         D_OUTPCB( ACTION ) implements the callbacks associated with ACTION.
%         ACTION = 1 : callback for the large pop-up-menu.
%                  2 : Callback for the "..." pushbutton, calls the "uigetfile"
%                      can be used as an alternative to manually entering
%                      the file name in the editable text area.
%                  3 : Set-up Userdata of the POLYNOMIAL checkbox based on 
%                      the array names in its editable text field, such that 
%                      when the APPLY pushbutton is pressed the specified
%                      variables are transfered to the base MATLAB workspace
%                      with the specified array names.  This will only happen
%                      if checkbox state changes from 0 to 1.
%                  4 : same as 3 but for the LATTICE checkbox.
%                  5 : same as 3 but for the SOS checkbox.
%                  6 : code generation.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%===================
%  GLOBAL variables
%===================
global  DFP_fir       DFP_firlat         ...
        DFP_bbQ       DFP_aaQ            ...
        DFP_top       DFP_bottom         ... 
        DFP_gain      DFP_SourceCodeDir

FIG5han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig5' );
FIG6han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig6' );
CHLDhan = get( FIG6han, 'Children' );
PUhan   = sort( findobj(CHLDhan,'flat','Style','popupmenu') );
PBhan   = sort( findobj(CHLDhan,'flat','Style','pushbutton'));
CBhan   = sort( findobj(CHLDhan,'flat','Style','checkbox' ) );
RB5han  = sort( findobj( get(FIG5han,'Children'), 'flat', ...
                                     'Style', 'radiobutton' ));
EThan   = sort( findobj(CHLDhan,'flat','Style','edit') );
ET5han  = sort( findobj(get(FIG5han,'Children'),'flat','Style','edit') );
RB51han = sort( findobj(RB5han,'flat','Tag','fixed')  );

if ( Action == 1 )

    set( PUhan(1), 'Enable', 'on' );
    CodeType = get( PUhan(1), 'Value' );
    h = findobj(CHLDhan,'flat','Tag','fig6:filtercode');
    if ( CodeType == 1 )
       flag = 'off';
       str  = str2mat( '', '' );
    else
       flag = 'on';
       if ( strcmp(get(ET5han(1),'Enable'),'off')) %==== unquantized coeff
          str = str2mat( 'Macro Code|Full Code', 'Coeff: Decimal' );
       else                                        %==== quantized coeff  
          str = str2mat( 'Macro Code|Full Code', ...
                         'Coeff: Decimal|Coeff: Hex|Coeff: Binary' );
       end
    end
    set( h(h~=PUhan(1)), 'Enable', flag )
    for ii = 2:length(PUhan)
        set( PUhan(ii), 'String', deblank(str(ii-1,:)) );
    end

elseif ( Action == 2 )

    CodeType = get( PUhan(1), 'Value' );
    FileArr  = str2mat( '*.asm', '*.asm', '*.c' );

    FIG6pos  = get(FIG6han,'Position');
    Position = [ sum(FIG6pos([1 3])) FIG6pos(2)/2 ];

    [ FileName, PathName ] = uiputfile( ...
              [ DFP_SourceCodeDir deblank(FileArr(CodeType,:)) ] , ...
               'DFP: Select File', Position(1), Position(2) );

    if ( ~PathName )
       return
    elseif ( ~isdir(PathName) )
       d_error( 'EG-01', PathName )
       set( EThan(4), 'String', ' ' );
       return
    else   
       set( EThan(4), 'String', [ ' ' PathName FileName ] );
    end

elseif ( Action == 3 )  %======= POLYNOMIAL transfer ==========

    if ( get(CBhan(1),'Value') )

       EThan = sort( findobj( CHLDhan, 'flat', 'Style', 'edit'     ) );
       str = get(EThan(1),'String');
       if ( isempty(str) )
          set( CBhan(1), 'Value', 0 )
          d_error( 'EO-01' )
          return
       else
          str = matqparse( str );
          if ( size(str,1) ~= 2 )
             set( CBhan(1), 'Value', 0 )
             d_error( 'EO-02' )
             return
          end
          %===============================================================
          %
          % Here, I introduce new global variables: DFP_tr?var#, where
          %    ? = p for polynomial
          %        l for lattice
          %        s for Second order Sections  
          % and where # equals to 1 or 2 depending on how many we need.
          % Why do I need these separate ones?  I can use DFP_aaQ, DFP_bbQ,
          % etc. but since these become visible in the base workplace, I 
          % cannot accord the possibility of having these variables to be
          % accidently deleted.
          %
          % The array names as indicated by the user in the editable text
          % fields of the [DFP: Output] window cannot be global variables,
          % as when the user calls CLOSE DFP menu option from the 
          % [DFP: Navigator] window all the global variables are cleared.
          %
          %===============================================================
          global DFP_trpvar1 DFP_trpvar2
          DFP_trpvar1 = DFP_bbQ; 
          DFP_trpvar2 = DFP_aaQ;

          set(CBhan(1),'Userdata', ...
              sprintf('%s = DFP_trpvar1; %s = DFP_trpvar2;', ...
                      deblank(str(1,:)), deblank(str(2,:))      ) ); 
       end

    end

elseif ( Action == 4 )  %======= LATTICE transfer ==========

    if ( get(CBhan(2),'Value') )

       EThan = sort( findobj( CHLDhan, 'flat', 'Style', 'edit'     ) );
       str = get(EThan(2),'String');
       if ( isempty(str) )
          set( CBhan(2), 'Value', 0 )
          d_error( 'EO-01' )
          return
       else
          str = matqparse( str );
          if ( DFP_fir )
             if ( size(str,1) ~= 1 )
                set( CBhan(2), 'Value', 0 )
                d_error( 'EO-03' )
                return
             end
             global DFP_trlvar1;
             DFP_trlvar1 = DFP_bottom;
             ss = sprintf('%s = DFP_trlvar1;', deblank(str(1,:)) );
          else
             if ( size(str,1) ~= 2 )
                set( CBhan(2), 'Value', 0 )
                d_error( 'EO-04' )
                return
             end
             global DFP_trlvar1  DFP_trlvar2;
             DFP_trlvar1 = DFP_top; 
                                                 DFP_trlvar2 = DFP_bottom;
             ss = sprintf('%s = DFP_trlvar1;  %s = DFP_trlvar2;', ...
                           deblank(str(1,:)), deblank(str(2,:))      );
          end
          set(CBhan(2),'Userdata',ss);
       end

    end

elseif ( Action == 5 )   %=========== SOS Transfer ==============

    if ( get(CBhan(3),'Value') )

       EThan = sort( findobj( CHLDhan, 'flat', 'Style', 'edit' ) );
       str = get(EThan(3),'String');
       if ( isempty(str) )
          set( CBhan(3), 'Value', 0 )
          d_error( 'EO-01' )
          return
       else
          str = matqparse( str );
          if ( size(str,1) ~= 2 )
             set( CBhan(3), 'Value', 0 )
             d_error( 'EO-05' )
             return
          end
          global DFP_trsvar1  DFP_trsvar2;
          DFP_trsvar1 = DFP_bottom; 
                                        DFP_trsvar2 = DFP_gain;
          set(CBhan(3),'Userdata', ...
              sprintf('%s = DFP_trsvar1;  %s = DFP_trsvar2;', ...
                       deblank(str(1,:)), deblank(str(2,:)) ) );
       end

    end

elseif ( Action == 6 )

    CodeType = get( PUhan(1), 'Value' );
    
    if ( CodeType == 1 )        %=== Do nothing ===

       return;  

    elseif ( CodeType == 2 )    %=== Motorola DSP56k Family ===

       FileName = strrep(get(EThan(4),'String'),' ','');
       if ( isempty(FileName) )
          d_error( 'WG-01' );
          return;

       %=================================================================
       % Until MathWorks fixes the modality problem with question dialog
       % box "questdlg", let us not worry about the possibility of
       % overwriting existing files.
       %=================================================================
       %elseif ( ~isempty( fwhich(FileName,'file') ) )
       %   str = str2mat( ...
       %            'The file',                          ...
       %    '        ',                          ...
       %           ['    ' FileName ],                   ...
       %    '        ',                          ...
       %            'exists.  Do you want to overwrite?'    );
       %   click = questdlg( str, 'Yes', 'No' ); 
       %   if ( strcmp(click,'no') )
       %      return;
       %   end

       end

       Fid = fopen( FileName, 'wt' );
       if ( Fid == -1 )
          d_error( 'EG-03', FileName );
          return
       end

       set( get(0,'Children'), 'Pointer', 'watch' );

       %======================================================================
       %  The number 14 (i.e. the variable Prec) is the number of identifiable
       %  decimal places in the floating point representation with 24 bit 
       %  coefficients.  This I have to check further.
       %======================================================================
       %  Here is a brief outline of what I am doing:
       %  -------------------------------------------
       %  1. if input coefficients are in floating point format, the call
       %     to "d_format" has to be of the form "d_format( in, 2, [ 0 23 ] )"
       %  2. if input coefficients are in fixed point format, first read the
       %     NTotal and NInteger values from Figure 5, then the requested
       %     coefficient format from the pop-up menu in Figure 6.  Subtract 1
       %     to allow matching to the "d_format" input parameters.
       %  3. as the Motorola assembler does not accept octal values modify
       %     the OutputFormat value again matching to "d_format" input par's.
       %======================================================================

       Prec = 14;

       if ( strcmp(get(ET5han(1),'Enable'),'off') | ...
            (get(PUhan(3),'Value') == 1) )
          InputFormat  = 2;
          OutputFormat = [ 0 Prec ];
       else
          InputFormat  = [ get(RB51han(1),'Value')            ...
                           str2num( get(ET5han(1),'String') ) ...    % NTotal
                           str2num( get(ET5han(2),'String') )     ]; % NInteger
          OutputFormat = get(PUhan(3),'Value')-1;
          if ( OutputFormat == 2 )
             OutputFormat = 3;
          end 
          OutputFormat = [ OutputFormat Prec ];
       end

       %====================================================================
       %
       %  1. Identify code type to be generated (Macro/Complete = 1/2) 
       %
       %  2. Identify the CoeffArray elements that will eventually be written
       %     to the output file as a function of the FIR/IIR and 
       %     DirectForm/Lattice/Biquad.
       %
       %====================================================================

       CodeType = get(PUhan(2),'Value');

       if ( DFP_fir & get(RB5han(1),'Value') )        %== FIR Direct Form 

          CoeffArray = DFP_bbQ;
          FilterType = 0;
          Options    = [ CodeType length(DFP_bbQ) ];

       elseif (  DFP_fir & get(RB5han(2),'Value') )   %== FIR Lattice Form

          CoeffArray = DFP_bottom;
          FilterType = 1;
          Options    = [ CodeType length(DFP_bottom) DFP_firlat/2 ];

       elseif ( ~DFP_fir & get(RB5han(1),'Value') )   %== IIR Direct Form

          CoeffArray = [ -DFP_aaQ(2:length(DFP_aaQ)) DFP_bbQ ]'/2;
          FilterType = 2;
          Options    = [ CodeType length(DFP_bbQ) ];

       elseif ( ~DFP_fir & get(RB5han(2),'Value') )   %== IIR Lattice Form

          CoeffArray = [ DFP_top(length(DFP_top):-1:1) ...
                         DFP_bottom(length(DFP_bottom):-1:1)  ];
          FilterType = 3;
          Options    = [ CodeType length(DFP_top) length(DFP_bottom) ];

       elseif ( ~DFP_fir & get(RB5han(3),'Value') )   %== IIR Biquads 

          CoeffArray = DFP_bottom(:,[6 5 3 2 1])/2;
          CoeffArray(:,[1 2]) = -CoeffArray(:,[1 2]);
          FilterType = 4;
          Options    = [ CodeType size(DFP_bottom,1) ];

       end

       %=======================================================================
       %
       %  We now to perform the following steps:
       %
       %  1. If the input coeffs are quantized and the requested output format
       %     is not "float", run the CoeffArray through "limiter".  Why?  The
       %     main characteristic of the Motorola assembler necessitates this
       %     step.  If a particular coeff in float in the assembler file has a
       %     magnitude > 1, then the assembler uses saturation arithmetic, such
       %     that the particular coeff is mapped onto (-1) or (1-Stepsize). But
       %     if the requested coeff format is binary/hex then the assembler 
       %     does not perform saturation arithmetic and takes the binary/hex
       %     value by its face value.  For example, with NTotal=24 and NInt=3
       %     the coeff "1.5 = 0001.100...0" is taken as "0.1875=0.00110..0"
       %     as the assembler expects each number to be in the range [-1,1).
       %     
       %  2. For coeff format in hex replace each leading "0x" with "$" to
       %     conform with the Motorola assembler syntax.
       %     
       %  3. For coeff format in binary delete the binary point placed by
       %     "d_format" and place a leading "%" to each coefficient again to
       %     conform with the Motorola assembler syntax.
       %
       %=======================================================================
       
       if ( length(InputFormat) > 1 )
          CoeffArray1 = limiter( CoeffArray, -1, (1-2^(-24)) );
          no = sum(sum( CoeffArray1 ~= CoeffArray ));
          if ( no )
             d_error('WO-01',no);
          end
          CoeffArray = CoeffArray1;
          InputFormat(3) = 0;   % for proper representation
       end

       CoeffArray = d_format( CoeffArray, InputFormat, OutputFormat );

       if ( OutputFormat(1) == 1 )  %=== Hexadecimal
          str_hdr = '$';
          CoeffArray = [ str_hdr(ones(size(CoeffArray,1),1),:) ...
          CoeffArray(:,3:size(CoeffArray,2)) ];
       elseif ( OutputFormat(1) == 3 )  %=== Binary
          str_hdr = '%';
          CoeffArray = [ str_hdr(ones(size(CoeffArray,1),1),:) ...
         CoeffArray(:,[1 3:size(CoeffArray,2)]) ];
       end

       d_codgen( CoeffArray, FilterType, Fid, Options );

       FileStatus = fclose( Fid );
       set( get(0,'Children'), 'Pointer', 'arrow' );
       if ( FileStatus == -1 )
          d_error( 'EG-04', FileName );
          return;
       end
       
    end

end


