function d_numncb()
%D_NUMNCB is the partial callback function for the OTHER-Menu in the 
%         "DISPLAY" window.
%
%         D_NUMNCB reads the user entered data from the editable data field
%         of the input dialog window which has been created when the "OTHER"
%         sub-menu option in the GDelay or Impulse Menus in the "DISPLAY"
%         window.  D_NUMNCB then checks this value for correctness, if 
%         corrects destroys the dialog box, and then calls the D_DPLYDR
%         function the have either the Group -Delay or the Impulse-Response
%         plot to be updated with the user entered number-of-points.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

NN = get(findobj(gcf,'Style','edit'),'string');
if ( isempty(NN) | (NN<=0) | (fix(NN)~=NN) )
   d_error('EG-07');
   return;
end

NN = str2num(get(findobj(gcf,'Style','edit'),'string'));
set( findobj('Type','uimenu','Tag','menu4:other'), 'Userdata', NN );
delete(gcf);
d_dplydr( [0 NaN 0], NN  );
