function d_navgcb( num, action )
%D_NAVGCB is the callback for the checkbox and pop-up-menu uicontrols 
%         of the "NAVIGATOR" window.
%
%         D_NAVGCB( ID, ACTION ). ID is the unique ID number associated
%         with each checkbox and pop-up-menu uicontrol in the "NAVIGATOR" 
%         window.  ACTION can be 0 (=CLOSE) or 1 (=OPEN) (if applicable).
%         If no ACTION is specified for the object ID, then what is to be
%         done is extracted from the Checked status of the object ID.
%         (ID is _NOT_ equal to the object handle.)

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

global DFP_alpha

FIGhan  = findobj( get(0,'Children'), 'flat', 'Tag', 'fig1' );
CHLDhan = get( FIGhan, 'Children');

if   (num == 0)   % Main DESIGN PB

     set(FIGhan,'Visible','on');
     return

elseif     (num == 1)   % Main DESIGN PB

     set(findobj(FIGhan,'tag','grp1'),'visible','on'); ...
     set(findobj(FIGhan,'tag','grp5'),'visible','off');
     return

elseif (num == 2)   % Main DISPLAY PB

     set(findobj(CHLDhan,'flat','Tag','grp2'),'visible','on'); ...
     set(findobj(CHLDhan,'flat','Tag','grp6'),'visible','off');
     set(findobj(get(0,'Children'),'flat','Tag','fig4'),'visible','on');
     return

elseif (num == 3)   % Main IMPLEMENT PB

     set(findobj(FIGhan,'Tag','grp3'),'visible','on'); ...
     set(findobj(FIGhan,'Tag','grp7'),'visible','off');
     return

elseif (num == 4)   % Secondary DESIGN/FILTER PB

     set(findobj(FIGhan,'tag','grp1'),'visible','off'); ...
     set(findobj(FIGhan,'tag','grp5'),'visible','on');
     FIGhan = [ findobj(get(0,'Children'),'flat','Tag','fig2') ...
                findobj(get(0,'Children'),'flat','Tag','fig3') ];
     CBhan  = [ findobj( CHLDhan,'flat', 'Type','uicontrol', ...
                           'Style','checkbox','Userdata','fig2') ...
                findobj( CHLDhan,'flat', 'Type','uicontrol', ...
                           'Style','checkbox','Userdata','fig3') ];
     action = 0;

elseif (num == 5)   % Secondary DISPLAY PB

     set(findobj(CHLDhan,'flat','Tag','grp2'),'visible','off'); ...
     set(findobj(CHLDhan,'flat','Tag','grp6'),'visible','on');
     set(findobj(get(0,'Children'),'flat','Tag','fig4'),'visible','off');
     return

elseif (num == 6)   % Secondary IMPLEMENT PB

     set(findobj(FIGhan,'tag','grp3'),'visible','off'); ...
     set(findobj(FIGhan,'tag','grp7'),'visible','on');
     FIGhan = [ findobj(get(0,'Children'),'flat','Tag','fig5') ...
                findobj(get(0,'Children'),'flat','Tag','fig6') ];
     CBhan  = [ findobj( CHLDhan,'flat', 'Type','uicontrol', ...
                           'Style','checkbox','Userdata','fig5') ...
                findobj( CHLDhan,'flat', 'Type','uicontrol', ...
                           'Style','checkbox','Userdata','fig6') ];
     action = 0;

elseif (num == 7)   % Type & Specifications CB

     CBhan  = findobj( CHLDhan,'flat', ...
                      'Type','uicontrol','Style','checkbox','Userdata','fig2');
     FIGhan = findobj(get(0,'Children'), 'flat', 'Tag' , 'fig2' );

elseif (num == 8)   % Method CB

     CBhan  = findobj( CHLDhan,'flat', ...
                      'Type','uicontrol','Style','checkbox','Userdata','fig3');
     FIGhan = findobj(get(0,'children'), 'flat', 'Tag' , 'fig3' );

elseif (num == 9)   % Pole-Zero

     FIG4han = findobj(get(0,'children'),'flat','Tag','fig4');
     PZMNhan = findobj( FIG4han, 'Type','uimenu', 'Tag','snp:pozero' );
     COEFhan = findobj( FIG4han, 'Type','uimenu', 'Tag','menu4:coeff');
     CB = get(findobj(CHLDhan,'flat','Style','checkbox','Userdata','poze'),...
              'Value' );
     if ( ~CB )
        d_resize(DFP_alpha);
        set([PZMNhan COEFhan],'Visible','off');
     else 
        d_resize(1/DFP_alpha);
        set([PZMNhan COEFhan],'Visible','on');
     end
     return

elseif (num == 10)   % Form/Coeff CB

     CBhan  = findobj( CHLDhan,'flat', ...
                      'Type','uicontrol','Style','checkbox','Userdata','fig5');
     FIGhan = findobj(get(0,'children'), 'flat', 'Tag' , 'fig5' );

elseif (num == 11)   % Output CB

     CBhan  = findobj( CHLDhan,'flat', ...
                      'Type','uicontrol','Style','checkbox','Userdata','fig6');
     FIGhan = findobj(get(0,'children'), 'flat', 'Tag' , 'fig6' );

elseif (num == 12)   % Phase/GD/Impulse PU

     PUhan  = findobj(CHLDhan,'flat',...
              'Type','uicontrol','Style','popupmenu','Userdata','fig1:popup');
     set( PUhan, 'Value', action );
     return

end

if (  ~exist('action') )
     action = get( CBhan, 'Value' );
     end

if ( action )
     set(FIGhan,'Visible','on');
     set(CBhan, 'Value',   1  );
else
     set(FIGhan,'Visible','off');
     set(CBhan, 'Value',   0  );
     end


