function  name = d_namesv( index )
%D_NAMESV is the figure title/name database server.
%
%         When a figure is to be created the name of this figure which will
%         appear in its titlebar, the figure creation function inquires this
%         server to get the title.
%
%         Each figure has a number associated with it as shown below.  Note
%         that depending on the figures which may be open when DFP has started
%         this number may or may not correspond to the actual figure handle.
%
%         NAME = D_NAMESV( FIGNO ) returns the string NAME corresponding to 
%         the DFP figure with DFP index FIGNO.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

FigureName_array = str2mat( ...
                     'DFP: Navigator',                     ... % fig 1
                     'DFP: Type and Specifications',       ... % fig 2
                     'DFP: Design Method ',                ... % fig 3
                     'DFP: Display',                       ... % fig 4
                     'DFP: Implementation',                ... % fig 5
                     'DFP: Output Format',                 ... % fig 6
                     'DFP: File I/O',                      ... % fig 7
                     'DFP: Properties',                    ... % fig 8
                     'DFP: About'                          ... % fig 9
                    );
FigureName_array = str2mat( ...
                      FigureName_array,                    ...
                     'DFP: Magnitude Axes',                ... % fig 10
                     'DFP: Phase Axes',                    ... % fig 11
                     'DFP: Group Delay',                   ... % fig 12
                     'DFP: Impulse Response',              ... % fig 13
                     'DFP'                                 ... % fig 14
                    );

name = deblank( FigureName_array(index,:) );
