function d_mtdsup( FILTtypeNumber )
%D_MTDSUP prepares Userdata of the radiobuttons in the "DESIGN METHOD" window
%
%         This function is called by pressing the APPLY pushbutton of the
%         "TYPE and SPECIFICATIONS" window, which updates the filter 
%         parameters based on the user entered data in the editable fields.
%         In this function we read this data, translate them to filter
%         variables such as "deviation", "weight", etc, estimates the filter
%         order, and sets the Userdata of each radiobutton in the "DESIGN
%         METHOD" window to a string which will then be read in the function
%         D_MTDCB and "eval"-uated.    The estimated filter order values
%         will be written in the "estimate" text fields of the "DESIGN
%         METHOD" window.  Also, the estimated filter order values are 
%         entered into the SET order editable text fields to be used as
%         initial values.
%
%         D_MTDSUP( FiltTypeNumber ) requires the input argument
%         FiltTypeNumber which equals 1 (=LPF), 2 (=HPF), 3 (=BPF), 4 (=BSF),
%         5 (=Diff), 6 (=Hilbert).
%
%         It is also here where we enable/disable "DESIGN METHOD" radiobuttons.
%         for example for Diff/Hilbert we have only the REMEZ and FIRLSA
%         methods available, therefore disable everything else.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%====================
%  GLOBAL variables
%====================
global DFP_fs

FILTdata = get(findobj(get(0,'Children'),'flat','Tag','fig2'), 'Userdata' );
FILTdata = FILTdata( FILTtypeNumber, : );

CHLDhan=  get(findobj(get(0,'Children'),'flat','Tag','fig3'),'Children');
TXhan  = sort(findobj(CHLDhan,'flat','Tag','text3:estimate'));
EDhan  = sort(findobj(CHLDhan,'flat','Type','uicontrol','Style','edit'));
RBhan  = sort(findobj(CHLDhan,'flat','Type','uicontrol','Style','radiobutton'));
PUhan  =      findobj(CHLDhan,'flat','Type','uicontrol','Style','popupmenu');


if ( FILTtypeNumber == 1 )  %  LPF

    fs = FILTdata(1);
    fp = FILTdata(2);
    Ap = FILTdata(3);
    fc = FILTdata(4);
    Ac = FILTdata(5);
   
    dev = [ (10^(Ap/20)-1)/(10^(Ap/20)+1)  10^(-Ac/20) ];
    wgt = [ 1 0 ];
    fre = [ fp fc ];

    fp = fp/(fs/2);  fc = fc/(fs/2);
    ss = [];
    f = (fp+(fc-fp)/5);

elseif ( FILTtypeNumber == 2 )  %  HPF

    fs = FILTdata(1);
    fc = FILTdata(2);
    Ac = FILTdata(3);
    fp = FILTdata(4);
    Ap = FILTdata(5);

    dev = [ 10^(-Ac/20) (10^(Ap/20)-1)/(10^(Ap/20)+1) ];
    wgt = [ 0 1 ];
    fre = [ fc fp ];

    fp = fp/(fs/2);  fc = fc/(fs/2);
    ss = ',''high''';
    f = (fp+(fc-fp)/5);

elseif ( FILTtypeNumber == 3 )  %  BPF

    fs  = FILTdata(1);
    fc1 = FILTdata(2);
    Ac1 = FILTdata(3);
    fp1 = FILTdata(4);
    Ap  = FILTdata(5);
    fp2 = FILTdata(6);
    fc2 = FILTdata(7);
    Ac2 = FILTdata(8);

    dev=[10^(-Ac1/20) (10^(Ap/20)-1)/(10^(Ap/20)+1) 10^(-Ac2/20)];
    wgt = [ 0 1 0 ];
    fre = [ fc1 fp1 fp2 fc2 ];

    Ac = max(Ac1,Ac2); fp = [fp1 fp2]/(fs/2);  fc = [fc1 fc2]/(fs/2);
    ss = [];
    f = (fp+(fc-fp)/5);

elseif ( FILTtypeNumber == 4 )  %  BSF

    fs  = FILTdata(1);
    fp1 = FILTdata(2);
    Ap1 = FILTdata(3);
    fc1 = FILTdata(4);
    Ac  = FILTdata(5);
    fc2 = FILTdata(6);
    fp2 = FILTdata(7);
    Ap2 = FILTdata(8);

    dev=[ (10^(Ap1/20)-1)/(10^(Ap1/20)+1) 10^(-Ac/20) ...
                               (10^(Ap2/20)-1)/(10^(Ap2/20)+1) ];
    wgt = [ 1 0 1 ];
    fre = [ fp1 fc1 fc2 fp2 ];

    Ap = min(Ap1,Ap2); fp = [fp1 fp2]/(fs/2);  fc = [fc1 fc2]/(fs/2);
    ss = ',''stop''';
    f = (fp+(fc-fp)/5);

elseif ( FILTtypeNumber == 5 )  %  Differentiator

    fs  = FILTdata(1);
    typ = FILTdata(2); 
    err = FILTdata(3);
    fc  = FILTdata(4); 
    slp = FILTdata(5); 

    arr1 = [0 fc/(fs/2)];
    arr2 = mat2str( slp*arr1, 5 );
    arr1 = mat2str(   arr1,   5 );

    [ No, Ne ] = difford( err, fc, fs );
    if ( typ == 3 ) 
       Order = Ne;
    else
       Order = No;
    end

    fstr = '''differentiator''';

elseif ( FILTtypeNumber == 6 )  %  Hilbert

    fs  = FILTdata(1);
    typ = FILTdata(2);
    err = FILTdata(3);
    fc1 = FILTdata(4);
    fc2 = FILTdata(5);

    arr1 = mat2str( [ fc1  fc2 ]/(fs/2), 5 );
    arr2 = mat2str( [  1    1  ]       , 5 );

    N = hilbord( err, min(fc1,fc2), fs );
    if ( typ == 3 ) 
       Order = 2*ceil(N/2); 
    else
       Order = 2*ceil(N/2)+1;
    end

    fstr = '''hilbert''';

end

if ( sum( FILTtypeNumber == [1 2 3 4] ) )

   [ Nrem, fo_rem, mo_rem, w_rem ] = remezord(  fre, wgt, dev, fs );
   [ Nkai, beta ] = kaiseord(  fre, dev, fs );
   [ Nbut, wbut ] =  buttord( fp, fc, Ap, Ac );
   [ Ncb1, wcb1 ] = cheb1ord( fp, fc, Ap, Ac );
   [ Ncb2, wcb2 ] = cheb2ord( fp, fc, Ap, Ac );
   [ Neli, weli ] = ellipord( fp, fc, Ap, Ac );

   %======================================================================
   % Remez may and will complain if order is less than 3.  Since I cannot
   % capture that error message in DFP, I force the minimum remez order 
   % to be 3.
   %======================================================================
   Nrem   = max( 3, Nrem );
   Order  = [ Nrem, Nkai, Nrem, Nbut, Ncb1, Ncb2, Neli ];
   DFP_fs = fs;
   RBusr  = str2mat(                                                      ...
    ['remez( NN,[' sprintf('%g ',fo_rem) '],[' sprintf('%g ',mo_rem)      ...
             '],[' sprintf('%g ',w_rem ) '])' ],                          ...
    [  'fir1(NN,[' sprintf('%g ',f)    ']' sprintf('%s',ss) ',WINDOW)' ], ...
    ['firlsa( NN,[ ' sprintf('%g ',fo_rem) '],[ ' sprintf('%g ',mo_rem)   ...
             '],[ ' sprintf('%g ',w_rem) '])' ],                          ...
    ['butter(NN,[' sprintf('%g ',wbut) ']' sprintf('%s',ss) ')' ],        ...
    ['cheby1(NN,[' sprintf('%g ',Ap) '],[' sprintf('%g ',wcb1) ']'        ...
             sprintf('%s',ss) ')' ],                                      ...
    ['cheby2(NN,[' sprintf('%g ',Ac) '],[' sprintf('%g ',wcb2) ']'        ...
             sprintf('%s',ss) ')' ],                                      ...
    [ 'ellip(NN,[' sprintf('%g ',Ap) '],[' sprintf('%g ',Ac) '],['        ...
             sprintf('%g ',weli) ']' sprintf('%s',ss) ')' ],              ...
    [ 'pole-zero' ]                                                       ...
    );

   if ( sum( FILTtypeNumber == [2 4] ) )   % HPF/BSF and FIR needs NN=even
       Order(1:3) = 2*ceil(Order(1:3)/2); 
   end

   for ii = 1:length(TXhan)
       set( TXhan(ii), 'String', sprintf(' %i',Order(ii)) );
       set( EDhan(ii), 'String', sprintf(' %i',Order(ii)), 'Enable', 'on' );
   end
   for ii = 1:length(RBhan)
       set(  RBhan(ii), 'Userdata' , deblank(RBusr(ii,:)), 'Enable', 'on' );
   end
   set( RBhan(8), 'Userdata' , '' , 'Enable', 'off' );
   set( PUhan, 'Userdata', beta , 'Enable', 'on');

else

    DFP_fs = fs;
    RBusr = str2mat( ...
                     ['remez(  NN,' arr1 ',' arr2 ','  fstr ')' ], ...
                      '',                                          ...
                     ['firlsa( NN,' arr1 ',' arr2 ','  fstr ')' ]);

   for ii = [1 3]
       set( TXhan(ii), 'String', sprintf(' %i',Order ) );
       set( EDhan(ii), 'String', sprintf(' %i',Order ) , 'Enable', 'on' );
       set( RBhan(ii), 'Userdata' , deblank(RBusr(ii,:)) );
   end
   for ii = [2 4:7]
       set( TXhan(ii), 'String',    ''                   ); 
       set( EDhan(ii), 'String',    '' , 'Enable', 'off' );
       set( RBhan(ii), 'Userdata' , '' , 'Enable', 'off' );
   end
   set( [ PUhan RBhan(8) ], 'Userdata' , '' , 'Enable', 'off' );

end
