function FIGhan = d_mtdint()
%D_MTDINT creates and initializes the "DESIGN METHOD" window and its children.
%
%         FIG = D_MTDINT returns the handle to the figure object which has 
%         been created by calling the function D_MTDINT.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

%=================
% GLOBAL variables
%=================
global DFP_UIcontrolBox_X  DFP_UIcontrolBox_Y  DFP_WinBorderOffset ...
       DFP_Frame2button    DFP_Offset2         DFP_Offset3         ...
       DFP_ETbgroundcolor  DFP_FigureResize    DFP_fs              ...
       DFP_UIbgroundcolor  DFP_ColorMonitor    DFP_ScaleX          ...
       DFP_ScaleY

%==============
% FIGURE NUMBER
%==============
FigNo = 3;

%===============================
%  Dimension definitions (local)
%===============================
Dim1  =   1;                  % FR to l/r FIG edge
Dim2  =   1;                  % FR to b FIG edge
Dim21 =   DFP_Frame2button;   % FR to t FIG edge
Dim3  = 8*DFP_Frame2button;   % how much to indent RBs rel to l FR  edge
Dim31 =   DFP_Frame2button;   % UI to l/r FR  edge
Dim4  =   DFP_Frame2button;   % UI to b/t FR  edge
Dim41 =   20 * DFP_ScaleY;    % UI to b/t FR  edge (for the PB FR)
Dim5  =   0;                  % Separation between RB FRs
Dim51 =   0;                  % Separation between lower RB and PB FRs
Dim6  = 4*DFP_Frame2button;   % Separation between RB and ET
Dim7  =   DFP_Frame2button;   % Separation between ET and TX

RBx = 140 * DFP_ScaleX;
RBy = DFP_UIcontrolBox_Y;
PBx = DFP_UIcontrolBox_X;
PBy = DFP_UIcontrolBox_Y;

LBx = 100 * DFP_ScaleX;
LBy = RBy;

TXx = 40 * DFP_ScaleX;
TXy = DFP_UIcontrolBox_Y - (4*DFP_ScaleY);

ETx = TXx + (5*DFP_ScaleX);
ETy = TXy;

%
%  FRAME objects
%===============
FRx   =   RBx +   Dim3 + Dim6 + ETx + Dim7 + TXx + Dim31;
FRy1  =   RBy + 2*Dim4;
FRy3  = 3*RBy + 2*Dim4;
FRy4  = 4*RBy + 2*Dim4;
FRyp  =   PBy + 2*Dim41;
FRpos = [
              Dim1  Dim2+FRyp+Dim51+FRy1+FRy4+2*Dim5  FRx  FRy3;
              Dim1  Dim2+FRyp+Dim51+FRy1+Dim5         FRx  FRy4;
              Dim1  Dim2+FRyp+Dim51                   FRx  FRy1;
              Dim1  Dim2                              FRx  FRyp;
        ];

%
% PUSHBUTTON  objects
%=======================
Dim   = (FRx - 2*PBx)/3;
PBpos = [ 
         FRpos(4,1)+  Dim      FRpos(4,2)+Dim41   PBx  PBy ;
         FRpos(4,1)+2*Dim+PBx  FRpos(4,2)+Dim41   PBx  PBy ;
        ];
PBcb  = str2mat( 'd_mtdcb', 'd_navgcb(8,0)' );
PBstr = str2mat( 'Apply', 'Close' );

%
% RADIOBUTTON objects
%====================
co1 = Dim3 * ones(8,1);
co3 =  RBx * ones(8,1);
co4 =  RBy * ones(8,1);
co2 = [ 
        (FRpos(1,2)+Dim4) + RBy*[2:-1:0]';
        (FRpos(2,2)+Dim4) + RBy*[3:-1:0]';
        (FRpos(3,2)+Dim4)                ;
            ];
RBpos = [ co1 co2 co3 co4 ];
RBstr = str2mat( 'Remez'       , ''            , 'Least Square' , ...
                 'Butterworth' , 'Chebychev I' , 'Chebychev II' , ...
                 'Elliptic'    , 'Pole-zero' );
RBebl = str2mat( 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'off' );

%
%  POPUP MENU object
%===================
PUpos = RBpos(2,:);
        PUpos(1) = PUpos(1)+DFP_Offset2;
        PUpos(2) = PUpos(2)            ; 
        PUpos(3) = PUpos(3)-DFP_Offset2;
        PUpos(4) = PUpos(4)            ;
PUstr = 'Kaiser|Bartlett|Blackman|Hamming|Hanning|Boxcar';

%
%   If the computer type is PCWIN, then I have to modify the length of 
%   the 'Window' radiobutton which is overlapped by the pop-up menu, 
%   otherwise I cannot get the desired operation of this radiobutton
%   together with the pop-up menu.
%=====================================================================
if ( strcmp(computer,'PCWIN') )
   RBpos(2,3) = DFP_Offset2;
end

%
%  EDITABLE TEXT objects
%=======================
ETpos = [ RBpos(1:7,1)+RBx+Dim6  RBpos(1:7,2) ETx*ones(7,1) ETy*ones(7,1) ];

%
%  TEXT objects
%==============
TXpos = ETpos;
        TXpos(:,1) = TXpos(:,1) + ETx + Dim7;
TXtag = 'text3:estimate';
if ( DFP_ColorMonitor )
   TXfgc = [0 0 1];
else
   TXfgc = [0 0 0];
end

%
%  LABEL objects
%  These are really TEXT objects, but they will remain unchanged
%===============================================================
LBpos = [
          FRpos(1,1)+Dim31  FRpos(1,2)+FRy3-Dim4-LBy  LBx LBy;
          FRpos(2,1)+Dim31  FRpos(2,2)+FRy4-Dim4-LBy  LBx LBy;
          ETpos(1,1)        FRpos(1,2)+FRpos(1,4)     TXx LBy;
          TXpos(1,1)        FRpos(1,2)+FRpos(1,4)     TXx LBy;
          ETpos(1,1)+Dim6   FRpos(1,2)+FRpos(1,4)+TXy LBx LBy;
          ];
LBstr = str2mat( 'FIR' , 'IIR' , 'Set' , 'Estim.' , 'ORDER' );

%===============
%  Create FIGURE 
%===============
REFpos = get(findobj(get(0,'children'),'flat','Tag','fig1'),'Position');
FIGx   = FRx+2*Dim1;
FIGy   = FRyp+Dim51+FRy1+FRy4+FRy3+2*Dim5+2*Dim2+2*TXy;
FIGpos = [ DFP_WinBorderOffset+REFpos(1) REFpos(2)-FIGy-DFP_Offset3]; 
FIGhan = figure( ...
                'Position',     [FIGpos FIGx FIGy],       ...
                'Name',          d_namesv(FigNo),         ...
                'Color',         DFP_UIbgroundcolor,      ...
                'MenuBar',      'none',                   ...
                'Visible',      'off',                    ...
                'Backingstore', 'off',                    ...
                'Tag',         ['fig' num2str(FigNo)],    ...
                'Resize',        DFP_FigureResize,        ...
                'NextPlot',     'new',                    ...
                'UserData',      1,                       ...
                'NumberTitle',  'off'                     ...
               );


%============================
% Create and place UI objects
%============================
%
% FRAME objects
%==============
for ii = 1:size(FRpos,1)
    uicontrol( FIGhan,                                    ...
              'Style',              'Frame',              ...
              'Position',            FRpos(ii,:) );
end

%
% LABEL objects
%==============
for ii = 1:size(LBpos,1)
    uicontrol( FIGhan,                                    ...
              'Style',              'Text',               ...
              'HorizontalAlignment','left',               ...
              'Position',            LBpos(ii,:),         ...
              'String',              deblank(LBstr(ii,:)) ...
             );
end


%
% RADIOBUTTON objects
%====================
for ii = 1:size(RBpos,1)
    uicontrol( FIGhan,                                    ...
              'Style',              'radiobutton',        ...
              'HorizontalAlignment','left',               ...
              'Callback',            sprintf('d_mtdcb(%i)',ii), ...
              'Position',            RBpos(ii,:),         ...
              'Enable',              RBebl(ii,:),         ...
              'String',              deblank(RBstr(ii,:)) ...
             );
end

%
% POP-UP MENU object
%====================
    uicontrol( FIGhan,                                    ...
              'Style',              'Popup',              ...
              'String',              PUstr,               ...
              'Callback',           'd_mtdcb(2)',    ...
              'Position',            PUpos );

%
%  TEXT objects
%==============
for ii = 1:size(TXpos,1)
    uicontrol( FIGhan,                                    ...
              'Style',              'text',               ...
              'HorizontalAlignment','center',             ...
              'Position',            TXpos(ii,:),         ...
              'ForegroundColor',     TXfgc,               ...
              'Tag',                 TXtag                ... 
              ); 
end

%
%  EDITABLE TEXT objects
%=======================
for ii = 1:size(ETpos,1)
    uicontrol( FIGhan,                                    ...
              'Style',              'Edit',               ...
              'HorizontalAlignment','left',               ...
              'Position',            ETpos(ii,:),         ...
              'BackGroundColor',     DFP_ETbgroundcolor   ...
             ); 
end

%
% PUSHBUTTON objects
%===================
for ii = 1:size(PBpos,1)
    uicontrol( FIGhan,                                    ...
              'Style',              'pushbutton',         ...
              'HorizontalAlignment','center',             ...
              'Position',            PBpos(ii,:),         ...
              'Callback',            deblank( PBcb(ii,:)),...
              'String',              deblank(PBstr(ii,:)) ...
              );
end

%
% FIG has been set-up.
% Normalize all units for possible RESIZE operations.
% Then, return to the main program.
%=====================================================

set( get(FIGhan,'Children'), 'Units', 'normalized' );

