function d_mtdcb( FILTmethodNumber )
%D_MTDCB is the callback function for the "DESIGN METHOD" window.
%
%        If any one of the radiobuttons or the APPLY pushbutton in the
%        "DESIGN METHOD" window is pressed then this function is called.
%        It performs the following functions:
%         1. mutually exclusive property of radiobuttons if necessary
%         2. Read user set filter order.
%         3. error checking (for example, is N > 0?), check special order 
%            requirements for HPF/BSP/DIFF/HILBERT.
%         4. Is a new TARGET required?
%         5. Read the Userdata of the radiobutton and EVAL it, this will
%            generate the DFP_aa and DFP_bb polynomials.
%         6. Open the "DISPLAY" window and draw the magnitude response

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%===================
%  GLOBAL variables
%===================
global  DFP_bb   DFP_aa   DFP_fir  DFP_fs

FIG3han =      findobj(get(  0,    'Children'),'flat','Tag',  'fig3'       );
RBhan   = sort(findobj(get(FIG3han,'Children'),'flat','Style','radiobutton'));

%=====================================================
%  First take care of the mutually exclusive property
%  of the radiobuttons.
%=====================================================

if ( nargin == 1 )  %==== Entry point for RB callbacks =====

   set( RBhan( FILTmethodNumber ), 'Value', 1 );
   set( RBhan( [1:length(RBhan)] ~= FILTmethodNumber ), 'Value', 0 );
   return;

else               %==== Entry point for the APPLY PB callback =====

   FILTmethodNumber = find( RBhan==findobj(RBhan,'flat','Value',1) );
   if ( isempty(FILTmethodNumber) )
      d_error( 'EM-01' );
      return
   end

end

FIG1han =      findobj(get(0,'Children'),'flat','Tag','fig1');
EThan   = sort(findobj(get(FIG3han,'Children'),'flat','Style','edit'));
DESIGNf = get( RBhan(FILTmethodNumber), 'Userdata' );

%====================================================================
%  Has the RBs properly set-up by an earlier call to D_TSPCB?
%====================================================================
if ( isempty(DESIGNf) )
   d_error( 'EM-02' );
   return
end

NN = str2num(get(EThan(FILTmethodNumber),'String'));
%=============================
%  Is the filter order proper?
%=============================
if ( isempty(NN) )
   d_error( 'EM-03' );
   return
end
if ( NN <= 0 )
   d_error( 'EM-03' );
   return
end
if ( (NN < 3) & (FILTmethodNumber == 1) ) 
   d_error( 'EM-04' );
   return
end
if ( round(NN) ~= NN )
   d_error( 'WM-02' );
   NN = round(NN);
   set(EThan(FILTmethodNumber),'String',[' ' num2str(NN)]);
end

set( get(0,'Children'), 'Pointer', 'watch' ); 

%===========================================================
% Do we need to redraw the target? Yes, if method has changed
% from FIR to IIR or vice versa.
% FIR --> FILTmethodNumber = {1,2,3}
%===========================================================

if ( xor( DFP_fir, sum(FILTmethodNumber == [1 2 3]) ) )
   NEWTARGETflag = 1;
else
   NEWTARGETflag = 0;
end

DFP_fir = sum( FILTmethodNumber == [1 2 3] );

FiltType = ...
 get(findobj(get(findobj(get(0,'Children'),'flat','Tag','fig2'),'Children'),...
 'flat','Style','popupmenu'),'Value');

%=======================================================================
% If HPF/BSF and FIR we should have NN=even, otherwise we get complaints
%=======================================================================

if ( sum(FiltType==[2 4]) & DFP_fir )
   NE = 2*ceil(NN/2); 
   if ( NN ~= NE )
      set( EThan(FILTmethodNumber), 'String', [' ' num2str(NE)] );
      d_error( 'WM-01', NN, NE );
      NN = NE;
   end
end

%=======================================================================
% If DIFFERENTIATOR/HILBERT we should have NN=even/odd for Type IV/III 
% filters, otherwise we get complaints
%=======================================================================

if ( sum( FiltType == [5 6] ) ) 
   ET2han = sort(findobj(get(findobj(get(0,'Children'),'flat','Tag','fig2'),...
                        'Children'),'flat','Style','edit'));
   TYPE = str2num( get(ET2han(2),'String') );
   NE   = 2*ceil(NN/2); 
   if ( (TYPE==3) & (NN~=NE) )     % NN even?
      d_error( 'WM-03', NN );
   elseif ( (TYPE==4) & (NN==NE) ) % NN odd?
      d_error( 'WM-04', NN );
   end
end

%===========================================================
% Do we need have to find a WINDOW function?
% Yes, if FILTmethodNumber = 2
%===========================================================

if ( FILTmethodNumber == 2 )

   PUhan   = findobj(get(FIG3han,'Children'),'flat','Style','popupmenu');
   windows = get( PUhan, 'String' );
   index   = get( PUhan, 'Value'  );
   windows = lower(deblank(windows(index,:)));
   if ( strcmp('kaiser',windows))
       beta   = get( PUhan, 'Userdata');
       WINDOW = eval( [ windows sprintf('(%i,%g)',NN+1,beta) ] );
   else
       WINDOW = eval( [ windows sprintf('(%i)',NN+1) ] );
   end

end

%========================================================
% Everything has been set up, let's evaluate the filter
% numerator (b) and denominator (a) polynomials
%========================================================
MENUhan = findobj( get( findobj(get(0,'Children'),'flat','Tag','fig4'), ...
                       'Children'), 'Type', 'uimenu' );
SCALE   = strcmp(get(findobj(MENUhan,'flat','Tag','menu4:db'),'checked'),'on');

[ DFP_bb, DFP_aa ] = eval(DESIGNf);

if ( NEWTARGETflag )
  [x,y,z] = d_tgtgen;
  d_tgdraw(x,y,z);
  d_tgmncb(get(findobj(MENUhan,'flat','Tag','menu4:target'),'checked'));
end

d_setlbl(2,FILTmethodNumber); 

d_recocb(8,1);             %==== Coeff: FLOAT
d_recocb(10);              %==== Reali: disable SOS if FIR
d_recocb(1);               %==== Reali: POLYNOMIAL 
d_implmt;                  %==== Coeff: prepare and execute COEFF display
d_dplydr([1 1 1],[1 1])    %==== Update all axes in DISPLAY window
d_scmncb( SCALE );         %==== Set the magnitude plot scale
d_navgcb( 12, 1 );         %==== Set DISPLAY:Phase/GD/Impulse PopUp to "Phase"

set( findobj(FIG1han,'Type','uimenu', 'Tag','fig1:uimenu:save'),'Enable','on' );
set( get(0,'Children'), 'Pointer', 'arrow');


