function d_logo()
%D_LOGO sets up and creates the Help/About screen

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.4 $    $Date: 1997/03/11 16:18:10 $
%

%=================
% GLOBAL variables
%=================
global  DFP_WinBorderOffset  DFP_UIcontrolBox_X  DFP_UIcontrolBox_Y ...
        DFP_FIGbgroundcolor  DFP_Offset3         DFP_SlateBluecolor ...
        DFP_UIbgroundcolor   DFP_ver             DFP_ReleaseDate    ...
        DFP_ColorMonitor     DFP_ScaleX          DFP_ScaleY

%==============
% FIGURE NUMBER
%==============
FigNo = 9;

%==============================
% Dimension definitions (local)
%==============================
Dim1  = 0;                  % FR to l/r FIG edge
Dim2  = 0;                  % FR to b FIG edge
Dim3  = 10 * DFP_ScaleY;    % UI to b/t FR  edge (for PB FR)
PBx   = DFP_UIcontrolBox_X; % PUSHBUTTON object width
PBy   = DFP_UIcontrolBox_Y; % PUSHBUTTON object height
FIGx  = 400 * DFP_ScaleX;   % Figure width

%
% FRAME objects
%==============
FRx   =   FIGx;
FRy   =   PBy + 2*Dim3;
FRpos = [ Dim1 Dim2 FRx FRy ];

%
% PUSHBUTTON  objects
%=======================
PBpos = [ FRpos(1)+(FRx-PBx)/2  FRpos(2)+(FRy-PBy)/2   PBx  PBy ];

%==============
% Create FIGURE
%==============
REFpos = get(findobj(get(0,'children'),'flat','Tag','fig1'),'Position');
FIGy   = (250*DFP_ScaleY) + FRy; 
FIGpos = [DFP_WinBorderOffset+REFpos(1)+REFpos(3)/2 REFpos(2)-FIGy-DFP_Offset3];
FIGhan = figure(                                          ...
              'Position',      [FIGpos FIGx FIGy],        ...
              'Visible',       'off',                     ...
              'Name',           d_namesv(FigNo),          ...
              'Color',          DFP_UIbgroundcolor,       ...
              'MenuBar',       'none',                    ...
              'BackingStore',  'off',                     ...
              'Tag',          ['fig' num2str(FigNo)],     ...
              'NumberTitle',   'off',                     ...
              'NextPlot',      'new'                      ...
              );

%============================
% Create and place UI objects
%============================
%
% FRAME objects
%==============
    uicontrol( FIGhan,                                     ...
              'Style',              'Frame',               ...
              'Position',            FRpos                 ...
              );
%
% PUSHBUTTON objects
%===================
    uicontrol( FIGhan,                                     ...
              'Style',              'pushbutton',          ...
              'HorizontalAlignment','center',              ...
              'Position',            PBpos,                ...
              'Callback',           'close(gcf)',          ...
              'String',             'OK'                   ...
              );

%
% AXES object
%==============
axes( 'Position', [0 FRy/FIGy 1 1-FRy/FIGy] );
axis off;

%
% FONT sizes and name
%==============
if ( strcmp(computer,'PCWIN') )
   fs1 = 14;                  % FontSize for "DIGITAL ..."
   fs2 =  8;                  % FontSize for "Name" and "Address"
   fs3 =  6;                  % FontSize for "by" and "Copyright"
else
   fs1 = 20; 
   fs2 = 14;
   fs3 = 10;
end
fn  = 'Helvetica';


%
% Normalized Y-positions with respect to the AXES for the TEXT objects
%=====================================================================
H = [ 0.85 0.75 0.62 0.28 0.07];  %

%=======================================================
% Create and place the TEXT objects
%=======================================================
%                 DIGITAL FILTER  PACKAGE
%       Version: a.1    Release Date: 01.May.1996
%
%       by Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%    Department of Electrical and Computer Engineering
% 
%             Ryerson Polytechnic University
%          Toronto, Ontario M5B 2K3, CANADA
%
%           Copyright 1996, Mehmet Zeytinoglu
%                    All Rights Reserved
%=======================================================

%==================================
str = 'DIGITAL  FILTER  PACKAGE';
%==================================
text( 0.5, H(1), str, ...
      'FontName', fn, 'FontSize', fs1, 'FontWeight', 'bold', ...
      'HorizontalAlignment', 'center', 'Color', DFP_SlateBluecolor );

%=========================================================
str = str2mat('Version:', DFP_ver, 'Date:', DFP_ReleaseDate );
%=========================================================
if ( DFP_ColorMonitor )
   TXcolor = [1 1 0];
else
   TXcolor = [0 0 0];
end
D = text( [ 0.181 0.34 0.52 0.62 ], H(2)*[ 1 1 1 1 ], str );
set( D([1 3]), 'FontName', fn, 'FontSize', fs2, 'FontWeight', 'normal', ...
               'Color', [0 0 0], 'HorizontalAlignment', 'left');
set( D(2), 'FontName', fn, 'FontSize', fs2, 'FontWeight', 'normal', ...
               'Color', TXcolor, 'HorizontalAlignment', 'left');
set( D(4), 'FontName', fn, 'FontSize', fs2, 'FontWeight', 'normal', ...
               'Color', TXcolor, 'HorizontalAlignment', 'left');

%==============
%  by
%==============
text( 0.5, H(3), 'by', 'FontName', fn, 'Fontsize', fs3, 'FontWeight', ...
          'normal', 'Color', [0 0 0], 'HorizontalAlignment', 'center' );

%======================================================================
str = str2mat( '    MEHMET ZEYTINOGLU (mzeytin@ee.ryerson.ca)    ', ...
               'Department of Electrical and Computer Engineering', ...
               '         Ryerson Polytechnic University          ', ...
               '        Toronto, Ontario M5B 2K3, CANADA         ' );
%======================================================================
text( [ 0.50 0.50 0.50 0.50 ], H(4)+0.07*[3:-1:0], str, ...
      'FontName', fn, 'Fontsize', fs2, 'FontWeight', 'normal', ...
      'FontAngle', 'normal', 'Color', [0 0 0], 'HorizontalAlignment', 'center');

%=====================================================
str = str2mat('Copyright 1996, Mehmet Zeytinoglu', ...
              '      All Rights Reserved        '   );
%=====================================================
text( [ 0.50 0.50 ], [0.06 0]+H(5), str, ...
      'FontName', fn, 'Fontsize', fs3, 'FontWeight', 'normal', ...
      'Color', [0 0 0], 'HorizontalAlignment', 'center' );

%
% FIG has been set-up
%====================
set( get(FIGhan,'Children'), 'Units', 'normalized' );
set( FIGhan, 'Visible', 'on' )
