function d_grmncb( Action )
%D_GRMNCB is the callback function for the Grid/Menu in the "DISPLAY" window.
%
%         D_GRMNCB( AXES) toggles between the Grid ON/OFF states for the
%         grid lines in the AXES, where AXES = 1 indicates the Magnitude
%         axes, and AXES = 2 indicates the Phase/GDelay/Impulse axes.
%         It is also in this function where the Grid Menu items' "Checked"
%         status is manipulated.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

FIG4han = findobj( get(0,'Children'), 'flat', 'Tag', 'fig4' );

if ( Action == 1 )      %=== Magnitude AXES grid on/off ===

   MenuTag = 'menu4:grid1';
   AxesTag = 'axes:mag';

elseif ( Action == 2 )  %=== PHASE AXES grid on/off ===

   MenuTag = 'menu4:grid2';
   AxesTag = 'axes:pha';

end

MNhan  = findobj( get(FIG4han,'Children'), 'Type', 'uimenu', 'Tag', MenuTag);
Status = findobj( MNhan, 'Checked', 'on' );
AXhan  = findobj( get(FIG4han,'Children'), 'Type', 'axes',   'Tag', AxesTag);   

if ( Status ) 
   set( MNhan, 'Checked', 'off' );
   set( AXhan, 'Xgrid', 'off', 'Ygrid', 'off' );
else
   set( MNhan, 'Checked', 'on' );
   set( AXhan, 'Xgrid', 'on',  'Ygrid', 'on'  );
end
