% D_GLOBAL 
%
% This the script which initializes the variables and parameters
% that determine the look and feel of the windows, GUI elements.
% Furthermore, the default values to be displayed by some dialog 
% boxes are also specified in this file.  
%
% While many of GUI related variables will be shared by all the
% windows, some parameters (for example DFP_ArrowColor1, DFP_fir)
% will be used in their own specific windows.  Yet, it is easier
% to include all these parameters in a single file, for the ease
% of modifications.
%
% The following parameters can be modified through the 
% "DFP Navigator/Properties/Customize" menu choice:
%
% DFP_AXbgroundcolor  DFP_TARGETcolor    DFP_MAGcolor      DFP_PHASEcolor
% DFP_POLEcolor       DFP_ZEROcolor      DFP_POLEZEROaxis  DFP_FigureResize 
% DFP_Directory       DFP_SourceCodeDir  DFP_TemplatesDir  DFP_FREQZpoints 
%
%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.5 $    $Date: 1997/03/11 16:18:10 $
%
%===============================================================================

DFP_ver          = ' 1.0.1';            % DFP version 
DFP_ReleaseDate  = ' 10.March.1997';    % Release Date of this version

%======================
% Display definitions
%======================
DFP_ColorMonitor = strcmp( get(0,'BlackAndWhite'), 'off' );
DFP_ScreenSize   = get(0,'ScreenSize');

%==============================================================
% Display resolution and computer type dependent definitions
%==============================================================
% REMARKS: 
% (1) DFP_Offset3 is a measure which represents 
%       (height of window title bar) + (window frame)
% measured in pixels.  It determines the appropriate placement 
% of DFP figures. This is a function of the window manager and
% user customization. I do not know of a sure way of accurately 
% detecting it. Therefore, the DFP_Offset3 values represent
% an approximation.
%
% (2) For PCs the typical display resolution is 1024x768.  For
% SUN workstation typical display resolution is 1152x900. In 
% determining the DFP figure dimensions and the size of the GUI
% objects in those windows I have used the above resolutions as
% a guideline. Please note that during startup when DFP creates
% its figures all GUI objects are defined in units of "pixels".
% This is to speed the DFP start-up time as recommended by 
% Matworks.  Hence for smaller resolution display we must scale.
%
% (3) The "else" values are really for SunOS/Solaris. Let us
% hope these are also OK for other OSs.
%==============================================================

c = computer;            
if ( strcmp(c,'LNX86') ) 
    DFP_Offset3    = 48; 
    DFP_AXfontsize = 12; 
    DFP_Markersize =  6;   
elseif( strcmp(c,'PCWIN') )
    DFP_Offset3    = 48;  
    DFP_AXfontsize =  8;  
    DFP_Markersize =  4; 
else                    
    DFP_Offset3    = 26+52; 
    DFP_AXfontsize = 12;   
    DFP_Markersize =  6;     
end

if ( (DFP_ScreenSize(3) >= 1024) & (DFP_ScreenSize(4) >= 768) )
    DFP_ScaleX = 1;
    DFP_ScaleY = 1;
else
    DFP_ScaleX = min( DFP_ScreenSize(3)/1024, 1 );
    DFP_ScaleY = min( DFP_ScreenSize(4)/768, 1 );
end
DFP_Offset3 = DFP_Offset3 * DFP_ScaleY;

%=============================================
% Color definitions
%=============================================
GrayColor           = [0.701961 0.701961 0.701961];  % default UICONTROL
                                                     %  backgroundcolor
if ( DFP_ColorMonitor )

   DFP_FIGbgroundcolor = GrayColor * 0.70; % DISPLAY FIGURE background color
   DFP_UIbgroundcolor  = GrayColor;        % UICONTROL background color
   DFP_UIfgroundcolor  = [0 0 0];          % UICONTROL foreground color
   DFP_ETbgroundcolor  = GrayColor * 1.25; % editable text background color
   DFP_SlateBluecolor  = [71 60 139 ]/256;

   DFP_ArrowColor1     = [  0  0.9  0.9 ]; % turquoise
   DFP_ArrowColor2     = [  1   1    0  ]; % yellow

else

   DFP_FIGbgroundcolor = [ 0 0 0 ];
   DFP_UIbgroundcolor  = [ 1 1 1 ];
   DFP_UIfgroundcolor  = [ 0 0 0 ];
   DFP_ETbgroundcolor  = [ 1 1 1 ];
   DFP_SlateBluecolor  = [ 0 0 0 ];

   DFP_ArrowColor1     = [ 1 1 1 ];
   DFP_ArrowColor2     = [ 1 1 1 ]; 

end

%=============================================
%  First define the USER modifiable values
%  through the script DFPRCDEF.M
%=============================================

dfprcdef;

%=============================================
% Dimension definitions (global)
%=============================================
DFP_UIcontrolBox_X  = 100 * DFP_ScaleX;
DFP_UIcontrolBox_Y  =  25 * DFP_ScaleY;
DFP_WinBorderOffset =   5 * DFP_ScaleX;
DFP_Frame2button    =   6 * (DFP_ScaleX+DFP_ScaleY)/2;
DFP_Linewidth       =   2;
DFP_Offset1         =   2;               % TEXT separation from FR/PB boundary
DFP_Offset2         =  20 * DFP_ScaleX;  % PU shift right rel to PB/RB left

%=============================================
% Other definitions
%=============================================
DFP_AXfontweight    = 'normal';

%=============================================
% Initial filter specifications
%=============================================
DFP_initial = [
               48000  12000      4  15000      50      0      0   0 ;  %= LPF
               48000  10000     40  17000       5      0      0   0 ;  %= HPF
               48000   5000     40   7000       3  10000  13000  40 ;  %= BPF
               48000   5000      3   7000      30  10000  13000   3 ;  %= BSF
               48000      3    -20  22000       1      0      0   0 ;  %= Diff
               48000      3    -20   1000   23000      0      0   0 ;  %= Hilb
              ];
DFP_fir = 1;

%=============================================
% Default parameters used for DISPLAY
%=============================================
DFP_Targetmax      =  10;
DFP_Targetmin      = -40;
DFP_GRPDELAYpoints = 128;
DFP_IMPULSEpoints  = 128;

%=========================================================================
% Some initial values for filter parameters to eliminate error conditions, 
% if anyone starts pressing buttons BEFORE designing a filter.
%=========================================================================
DFP_fs           =  1;
DFP_aa           =  1;
DFP_bb           =  1;
DFP_aaQ          =  1;
DFP_bbQ          =  1;
DFP_bottom       =  1;
DFP_top          =  1;
DFP_gain         =  1;
DFP_bottomstr    = '';
DFP_bottomsymbol = 'a';
DFP_topstr       = '';
DFP_topsymbol    = 'b';


set( 0, 'DefaultFigureColor'             ,      DFP_FIGbgroundcolor,...
        'DefaultUicontrolBackGroundColor',      DFP_UIbgroundcolor, ...
        'DefaultUicontrolForeGroundColor',      DFP_UIfgroundcolor, ...
        'DefaultTextFontSize',                  DFP_AXfontsize,     ...
        'DefaultAxesColor',                     DFP_AXbgroundcolor, ...
        'DefaultAxesFontSize',                  DFP_AXfontsize,     ...
        'DefaultAxesFontWeight',                DFP_AXfontweight,   ...
        'DefaultLineMarkerSize',                DFP_Markersize         );

global   DFP_FIGbgroundcolor DFP_ETbgroundcolor DFP_AXbgroundcolor ...
         DFP_ArrowColor1     DFP_ArrowColor2    DFP_SlateBluecolor ...
         DFP_TARGETcolor     DFP_MAGcolor       DFP_PHASEcolor     ...
         DFP_POLEcolor       DFP_ZEROcolor      DFP_POLEZEROaxis   ...
         DFP_UIbgroundcolor

global   DFP_UIcontrolBox_X  DFP_UIcontrolBox_Y DFP_WinBorderOffset ...
         DFP_Frame2button    DFP_Offset1        DFP_Offset2         ...
         DFP_Offset3         DFP_Linewidth      DFP_FigureResize    ...
         DFP_ScaleX          DFP_ScaleY

global   DFP_fir             DFP_initial                            ...
         DFP_Targetmax       DFP_Targetmin                          ...
         DFP_FREQZpoints     DFP_GRPDELAYpoints DFP_IMPULSEpoints

global   DFP_fs              DFP_aa             DFP_bb              ...
         DFP_aaQ             DFP_bbQ            DFP_bottom          ...
         DFP_bottomstr       DFP_bottomsymbol   DFP_top             ...
         DFP_topstr          DFP_topsymbol      DFP_gain 

global   DFP_Directory       DFP_SourceCodeDir  DFP_TemplatesDir    ...
         DFP_ver             DFP_ReleaseDate    DFP_ColorMonitor
