function  y = d_format(x,arg2,ctype)
%D_FORMAT generates a string array in the specified format
%
%      Y = D_FORMAT(X,IF,OF) generates the string array Y which corresponds
%        to the input array X under the control of input format IF and the
%        output array OF.
%
%        IF = [0 N M ] --> input unsigned quantized float with N total and
%                          M integer bits
%           = [1 N M ] --> input 2's complement quantized float with N total 
%                          and M integer bits
%           = [2]      --> input is float quantized or unquantized
%
%        OF = [0]      --> output float with 5 decimal precision.
%           = [0 PREC] --> output float with PREC decimal precision.
%           = [1]      --> output in hexadecimal 
%           = [2]      --> output in octal 
%           = [3]      --> output in binary 
%
%        1. IF=[2] must be used _only_ with OF = [0 [prec]]
%        2. for OF=[1-3] size of output string is determined by N and M.

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

Btype  = arg2(1);

if ( Btype == 2 ) %=== float ===

   offset0 = 0;
   offset1 = 0;
   scale   = 1;

elseif ( Btype == 0 ) %=== unsigned ===

   Ntotal = arg2(2);
   Nint   = arg2(3);
   offset0 = 0;
   offset1 = 0;
   scale   = 2^(-(Nint-Ntotal));
   posit   = Nint;

elseif ( Btype == 1 ) %=== 2s complement ===

   Ntotal = arg2(2);
   Nint   = arg2(3);
   offset0 = 2^Nint;
   offset1 = 2^(Ntotal-1);
   scale   = 2^(-(Nint-Ntotal+1));
   posit   = Nint+1;

end

x = (x + [x<0]*offset0)*scale + [x<0]*offset1;
x = x';
x = x(:);

if ( ctype(1) == 0 )     %============================== float ===========

    if ( length(ctype) == 1 )
       num_format = '%.5f';
    else
       num_format = [ '%.' num2str(ctype(2)) 'f' ];
    end

    y = [];
    for nn = 1:size(x,1)
        y = str2mat( y, sprintf(num_format,x(nn)) );
    end
    y = y(2:size(x,1)+1,:);

elseif ( ctype(1) == 1 ) %============================== hex =============

    y = int2hex(x,ceil(Ntotal/4));

elseif ( ctype(1) == 2 ) %============================== octal ===========

   y = int2oct(x,ceil(Ntotal/3));

elseif ( ctype(1) == 3 ) %============================== binary ==========

   x = dec2bin(x,Ntotal);
   y = [ x(:,1:posit)  setstr('.'*ones(size(x,1),1))  x(:,posit+1:Ntotal) ];

end

