function d_fileio( Action )
%D_FILEIO implements the callback functions corresponding to the OPEN,
%         SAVE, and NEW menu items in the "NAVIGATOR" window.
%
%         DFP_FILEIO( 0 ) --> File-Menu OPEN Callback using "uigetfile"
%         DFP_FILEIO( 1 ) --> File-Menu SAVE Callback using "uiputfile"
%         DFP_FILEIO( 2 ) --> File-Menu CLEAR Callback clears workspace
%         DFP_FILEIO( 3 ) --> File-Menu CLOSE Callback closes DFP

%
%    Author: Mehmet Zeytinoglu (mzeytin@ee.ryerson.ca)
%            Department of Electrical and Computer Engineering
%            Ryerson Polytechnic University
%            Toronto, Ontario, M5B 2K3 
%            CANADA
%            
%    Copyright (c) 1997 Mehmet Zeytinoglu
%
%    $Revision: 1.3 $    $Date: 1997/03/11 16:18:10 $
%

%===================
%  GLOBAL variables
%===================
global  DFP_WinBorderOffset  DFP_Offset3    DFP_Directory    ...
        DFP_initial          DFP_fir        DFP_fs           ...
        DFP_aa               DFP_bb                          ...
        DFP_aaQ              DFP_bbQ                         ...
        DFP_bottom           DFP_bottomstr  DFP_bottomsymbol ...
        DFP_top              DFP_topstr     DFP_topsymbol    ...
        DFP_gain


figures = get(0,'children');

FIG1han = findobj(figures,'flat','Tag','fig1');
FIG2han = findobj(figures,'flat','Tag','fig2');
FIG3han = findobj(figures,'flat','Tag','fig3');
FIG4han = findobj(figures,'flat','Tag','fig4');
FIG5han = findobj(figures,'flat','Tag','fig5');
FIG6han = findobj(figures,'flat','Tag','fig6');

if ( Action == 3 )   %========= CLOSE DFP ==========

   FIG7han  = findobj(figures,'flat','Tag','fig7');
   FIG8han  = findobj(figures,'flat','Tag','fig8');
   FIG9han  = findobj(figures,'flat','Tag','fig9');
   FIG10han = findobj(figures,'flat','Name',d_namesv(10));
   FIG11han = findobj(figures,'flat','Name',d_namesv(11));
   FIG12han = findobj(figures,'flat','Name',d_namesv(12));
   FIG13han = findobj(figures,'flat','Name',d_namesv(13));
   FIG14han = findobj(figures,'flat','Name',d_namesv(14));

   close( [ FIG1han FIG2han FIG3han  FIG4han  FIG5han  FIG6han  FIG7han ...
            FIG8han FIG9han FIG10han FIG11han FIG12han FIG13han FIG14han ] );

   clear global
   return

end

set( figures, 'Pointer',  'watch' )

RB3han  = sort(findobj(get(FIG3han,'children'),'flat','Style','radiobutton'));
ET3han  = sort(findobj(get(FIG3han,'children'),'flat','Style','edit'));
PU3han  =      findobj(get(FIG3han,'children'),'flat','Style','popupmenu');
TX3han  = sort(findobj(get(FIG3han,'children'),'flat','Style','text', ...
                                               'Tag', 'text3:estimate'));
RB5han  = sort(findobj(get(FIG5han,'children'),'flat','Style','radiobutton'));
PU5han  = sort(findobj(get(FIG5han,'children'),'flat','Style','popupmenu'));
ET5han  = sort(findobj(get(FIG5han,'children'),'flat','Style','edit'));
TX5han  = sort(findobj(get(FIG5han,'children'),'flat','Style','text'));

CB6han  = sort(findobj(get(FIG6han,'children'),'flat','Style','checkbox'));
ET6han  = sort(findobj(get(FIG6han,'children'),'flat','Style','edit'));
PU6han  = sort(findobj(get(FIG6han,'children'),'flat','Style','popupmenu'));

ScreenSize = get(0,'Screensize');
FIG1pos    = get(FIG1han,'Position');
Position   = [ DFP_WinBorderOffset ScreenSize(4)-FIG1pos(2)+DFP_Offset3*(1/3)];

TITLE   = d_namesv(7);
filesep = '/';
c = computer;
if strcmp(c(1:2),'PC')
   filesep = '\';
elseif strcmp(c(1:2),'MA')
   filesep = ':';
elseif isvms
   filesep = '.]';
end

if ( Action == 0 )  % ===== OPEN file =======

   [ FileName, PathName ] = uigetfile( [DFP_Directory '*.mat'], ...
                                       TITLE, Position(1),Position(2));
   if ( ~PathName )

      set( figures, 'Pointer',  'arrow' )
      return  %=== if the user has pressed on the CANCEL button

   elseif( ~isdir(PathName) )

      d_error( 'EG-01', PathName )
      set( figures, 'Pointer',  'arrow' )
      return

   elseif ( isempty(fwhich([PathName FileName],'file')) )

      d_error( 'EG-06', FileName, PathName );
      set( figures, 'Pointer',  'arrow' )
      return;

   else

      eval( [ 'load ' PathName FileName ] );

      idx = findstr(filesep,PathName); 
      if ( idx ) 
         str = [ 'FILE: ' PathName(idx(length(idx)-1)+1:length(PathName)) ...
                          FileName ];
      else
         str = [ 'FILE: ' FileName ] ;
      end
      set( findobj(get(0,'Children'),'flat','Tag','fig4'), 'Name', ...
           [ d_namesv(4) '     '  str ] );

   end

   set( findobj(FIG2han,'Style','popupmenu'), 'Value', FIG2popupval );
   set( FIG2han, 'Userdata', FIG2userdata );
   d_tspsup( FIG2popupval );

   d_setlbl(1,FIG2popupval)

   [x,y,z]=d_tgtgen;
   if ( sum( FIG2popupval==[1:4 6] ) )
      d_tgdraw(x,y,z,0);
   else
      d_tgdraw(x,y,z,1);
   end
   d_tgmncb( 'enable' );

   %======================================================================
   %  Do the "fig3" callbacks, only if a Filter Design Method has been
   %  selected.  We can determine this condition by checking whether
   %  any one of the "RB3value" is greater than 0.
   %======================================================================

   d_mtdsup( FIG2popupval );

   set( ...
     findobj(findobj(get(0,'Children'),'flat','Tag','fig1'),'Type','uimenu',...
    'Tag','fig1:uimenu:save'), 'Enable', 'on' );

   for ii = 1:length(ET3han)
       set(ET3han(ii),'String',ET3string(ii,:));
       set(TX3han(ii),'String',TX3string(ii,:));
       set(RB3han(ii),'Value' ,RB3value(ii)   );
   end
   set( RB3han(ii+1), 'Value', RB3value(ii+1));
   set( PU3han,       'Value', PU3value      );

   if ( sum(RB3value) )
      d_mtdcb;
   end

   for ii = 1:length(ET5han)
       set(ET5han(ii),'String',ET5string(ii,:),'Enable',ET5enable(ii,:));
   end
   for ii = 1:length(RB5han)
       set(RB5han(ii),'Value' ,RB5value(ii),   'Enable',RB5enable(ii,:));
   end
   for ii = 1:length(TX5han)
       set(TX5han(ii),'Enable',TX5enable(ii,:));
   end
   set( PU5han, 'Value' , PU5value );

   for ii = 1:length(ET6han)
       set(ET6han(ii),'String',ET6string(ii,:),'Enable',ET6enable(ii,:));
   end
   for ii = 1:length(CB6han)
       set(CB6han(ii),'Value' ,CB6value(ii),   'Enable',ET6enable(ii,:));
   end
   for ii = 1:length(PU6han)
       set( PU6han(ii), 'Value', PU6value(ii), 'Enable', 'on' );
   end

   %=========================
   %  Same as above
   %=========================
   if ( sum(RB3value) )
      d_implmt; 
      d_dplydr([1 NaN 1]); 
      if ( sum( FIG2popupval==[1:4] ) )
         d_scmncb(1);
      else
         d_scmncb(0);
      end
   end

   for ii = 1:length(PU6han)
       set( PU6han(ii), 'Value', PU6value(ii) );
   end

elseif ( Action == 1  )   %===== SAVE File =======

   FIG2popupval = get( findobj(FIG2han,'Style','popupmenu'), 'Value' );
   FIG2userdata = get( FIG2han, 'Userdata' );

   ET3string = [];
   TX3string = [];
   for ii = 1:length(ET3han)
       ET3string     = str2mat( ET3string, get(ET3han(ii),'String') );
       TX3string     = str2mat( TX3string, get(TX3han(ii),'String') );
       RB3value(ii)  = get( RB3han(ii),'Value' );
   end
   ET3string       = ET3string(2:length(ET3han)+1,:);
   TX3string       = TX3string(2:length(TX3han)+1,:);
   RB3value(ii+1)  = get( RB3han(ii+1), 'Value' );
   PU3value        = get( PU3han,       'Value' );

   ET5string = [];
   ET5enable = [];
   for ii = 1:length(ET5han)
       ET5string = str2mat( ET5string, get(ET5han(ii),'String') );
       ET5enable = str2mat( ET5enable, get(ET5han(ii),'Enable') );
   end
   ET5string = ET5string(2:length(ET5han)+1,:);
   ET5enable = ET5enable(2:length(ET5han)+1,:);

   RB5enable = [];
   for ii = 1:length(RB5han)
       RB5value(ii) = get( RB5han(ii),'Value' );
       RB5enable    = str2mat( RB5enable, get(RB5han(ii),'Enable') );
   end
   RB5enable = RB5enable(2:length(RB5han)+1,:);

   TX5enable = [];
   for ii = 1:length(TX5han)
       TX5enable    = str2mat( TX5enable, get(TX5han(ii),'Enable') );
   end
   TX5enable = TX5enable(2:length(TX5han)+1,:);

   PU5value = get( PU5han, 'Value' );

   ET6string = [];
   ET6enable = [];
   for ii = 1:3
       ET6string = str2mat( ET6string, get(ET6han(ii),'String') );
       ET6enable = str2mat( ET6enable, get(ET6han(ii),'Enable') );
       CB6value(ii) = get(CB6han(ii),'Value');
   end
   ET6string = ET6string(2:4,:);
   ET6string = str2mat( ET6string, get(ET6han(4),'String') );
   ET6enable = str2mat( ET6enable(2:4,:), 'on' );
   for ii = 1:length(PU6han)
       PU6value(ii) = get( PU6han(ii), 'Value' );
   end

   [ FileName, PathName ] = uiputfile( [DFP_Directory '*.mat'], ...
                                       TITLE, Position(1),Position(2));
   if ( ~PathName )

      set( figures, 'Pointer',  'arrow' )
      return

   elseif( ~isdir(PathName) )

      d_error( 'EG-01', PathName )
      set( figures, 'Pointer',  'arrow' )
      return

   else

      s = [ 'save ' PathName FileName                             ...
                        ' FIG2popupval'                           ... 
                        ' FIG2userdata '                          ... 
                        ' ET3string RB3value  PU3value TX3string' ...
                        ' ET5string RB5value  PU5value'           ...
                        ' ET5enable TX5enable RB5enable'          ...
                        ' ET6enable ET6string  PU6value CB6value' ];
      eval(s);
      idx = findstr(filesep,PathName); 
      if ( idx ) 
         str = [ 'FILE: ' PathName(idx(length(idx)-1)+1:length(PathName)) ...
                          FileName ];
      else
         str = [ 'FILE: ' FileName ] ;
      end
      str = [ d_namesv(4) '     '  str ];
      set( findobj(get(0,'Children'),'flat','Tag','fig4'), 'Name', str );

   end

elseif ( Action == 2 )   %========= CLEAR current design ==========

   set( FIG2han, 'Userdata' , DFP_initial );
   DFP_fir = 1;

   AX4han  = findobj(get(FIG4han,'children'),'flat','Type','axes');
   ET4han  = findobj(get(FIG4han,'children'),'flat','Style','edit');
   SL4han  = findobj(get(FIG4han,'children'),'flat','Style','slider');
   TX4han  = findobj(get(FIG4han,'children'),'flat','Style','text', ...
                       'Tag', 'fig4:value');
   set( [ET3han; TX3han; ET4han; TX4han], 'String', '' );
   set( SL4han, 'Visible', 'off' );
   set( RB3han, 'Value', 0, 'UserData', '' );
   set( RB5han, 'Value', 0 );
   set( [RB5han([4 6]); PU3han; PU5han],  'Value', 1 );
   set( findobj(FIG2han,'Style','popupmenu'), 'Value', 1 );
   d_tspsup(1)
   for ii = 1:length(AX4han)
       delete( get(AX4han(ii),'Children') );
   end
   ptr_index = [7 8 4 2];
   for ii = 1:4
       d_setlbl( ii, ptr_index(ii) );
   end
   d_tgmncb( 'disable' );
   d_recocb ( 8, 1 );
   set( FIG4han,'Name', d_namesv(4));
   set( ...
     findobj(findobj(get(0,'Children'),'flat','Tag','fig1'),'Type','uimenu',...
    'Tag','fig1:uimenu:save'), 'Enable', 'off' );
   set(findobj(FIG4han,'Type','uimenu','Tag','menu4:target'),'Checked','off');

   DFP_fs           =  1;
   DFP_aa           =  1;
   DFP_bb           =  1;
   DFP_aaQ          =  1;
   DFP_bbQ          =  1;
   DFP_bottom       =  1;
   DFP_top          =  1;
   DFP_gain         =  1;
   DFP_bottomstr    = '';
   DFP_bottomsymbol = 'a';
   DFP_topstr       = '';
   DFP_topsymbol    = 'b';

   set( CB6han(1), 'Value', 0 );
   set( PU6han(1), 'Value', 1 );
   d_outpcb( 1 );
   set( ET6han, 'String', '' );
   set( [ RB5han; PU5han; ET5han; TX5han(1:3); CB6han(2:length(CB6han)); ...
                          ET6han(2:length(ET6han)); PU6han(1) ],  ...
       'Enable', 'off' );
end

set( figures, 'Pointer',  'arrow' )
